/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.metrics;

import com.google.common.base.Preconditions;
import io.opencensus.common.Clock;
import io.opencensus.common.Timestamp;
import io.opencensus.common.ToDoubleFunction;
import io.opencensus.implcore.internal.Utils;
import io.opencensus.implcore.metrics.Meter;
import io.opencensus.metrics.DerivedDoubleCumulative;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.export.Metric;
import io.opencensus.metrics.export.MetricDescriptor;
import io.opencensus.metrics.export.Point;
import io.opencensus.metrics.export.TimeSeries;
import io.opencensus.metrics.export.Value;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class DerivedDoubleCumulativeImpl
extends DerivedDoubleCumulative
implements Meter {
    private final MetricDescriptor metricDescriptor;
    private final int labelKeysSize;
    private final List<LabelValue> constantLabelValues;
    private final Timestamp startTime;
    private volatile Map<List<LabelValue>, PointWithFunction<?>> registeredPoints = Collections.emptyMap();

    DerivedDoubleCumulativeImpl(String name, String description, String unit, List<LabelKey> labelKeys, Map<LabelKey, LabelValue> constantLabels, Timestamp startTime) {
        ArrayList<LabelValue> constantLabelValues = new ArrayList<LabelValue>();
        ArrayList<LabelKey> allKeys = new ArrayList<LabelKey>(labelKeys);
        for (Map.Entry<LabelKey, LabelValue> label : constantLabels.entrySet()) {
            allKeys.add(label.getKey());
            constantLabelValues.add(label.getValue());
        }
        this.labelKeysSize = allKeys.size();
        this.metricDescriptor = MetricDescriptor.create((String)name, (String)description, (String)unit, (MetricDescriptor.Type)MetricDescriptor.Type.CUMULATIVE_DOUBLE, allKeys);
        this.constantLabelValues = Collections.unmodifiableList(constantLabelValues);
        this.startTime = startTime;
    }

    public synchronized <T> void createTimeSeries(List<LabelValue> labelValues, @Nullable T obj, ToDoubleFunction<T> function) {
        Utils.checkListElementNotNull((List)Preconditions.checkNotNull(labelValues, (Object)"labelValues"), "labelValue");
        ArrayList<LabelValue> labelValuesCopy = new ArrayList<LabelValue>(labelValues);
        labelValuesCopy.addAll(this.constantLabelValues);
        Preconditions.checkArgument((this.labelKeysSize == labelValuesCopy.size() ? 1 : 0) != 0, (Object)"Label Keys and Label Values don't have same size.");
        Preconditions.checkNotNull(function, (Object)"function");
        PointWithFunction<?> existingPoint = this.registeredPoints.get(Collections.unmodifiableList(labelValuesCopy));
        if (existingPoint != null) {
            throw new IllegalArgumentException("A different time series with the same labels already exists.");
        }
        PointWithFunction<T> newPoint = new PointWithFunction<T>(labelValuesCopy, obj, function, this.startTime);
        LinkedHashMap registeredPointsCopy = new LinkedHashMap(this.registeredPoints);
        registeredPointsCopy.put(labelValuesCopy, newPoint);
        this.registeredPoints = Collections.unmodifiableMap(registeredPointsCopy);
    }

    public synchronized void removeTimeSeries(List<LabelValue> labelValues) {
        ArrayList<LabelValue> labelValuesCopy = new ArrayList<LabelValue>((Collection)Preconditions.checkNotNull(labelValues, (Object)"labelValues"));
        labelValuesCopy.addAll(this.constantLabelValues);
        LinkedHashMap registeredPointsCopy = new LinkedHashMap(this.registeredPoints);
        if (registeredPointsCopy.remove(labelValuesCopy) == null) {
            return;
        }
        this.registeredPoints = Collections.unmodifiableMap(registeredPointsCopy);
    }

    public synchronized void clear() {
        this.registeredPoints = Collections.emptyMap();
    }

    @Override
    @Nullable
    public Metric getMetric(Clock clock) {
        Map<List<LabelValue>, PointWithFunction<?>> currentRegisteredPoints = this.registeredPoints;
        if (currentRegisteredPoints.isEmpty()) {
            return null;
        }
        if (currentRegisteredPoints.size() == 1) {
            PointWithFunction<?> point = currentRegisteredPoints.values().iterator().next();
            return Metric.createWithOneTimeSeries((MetricDescriptor)this.metricDescriptor, (TimeSeries)((PointWithFunction)point).getTimeSeries(clock));
        }
        ArrayList<TimeSeries> timeSeriesList = new ArrayList<TimeSeries>(currentRegisteredPoints.size());
        for (Map.Entry<List<LabelValue>, PointWithFunction<?>> entry : currentRegisteredPoints.entrySet()) {
            timeSeriesList.add(((PointWithFunction)entry.getValue()).getTimeSeries(clock));
        }
        return Metric.create((MetricDescriptor)this.metricDescriptor, timeSeriesList);
    }

    public static final class PointWithFunction<T> {
        private final List<LabelValue> labelValues;
        private final Timestamp startTime;
        @Nullable
        private final WeakReference<T> ref;
        private final ToDoubleFunction<T> function;
        @GuardedBy(value="this")
        private double value = 0.0;

        PointWithFunction(List<LabelValue> labelValues, @Nullable T obj, ToDoubleFunction<T> function, Timestamp startTime) {
            this.labelValues = labelValues;
            this.startTime = startTime;
            this.ref = obj != null ? new WeakReference<T>(obj) : null;
            this.function = function;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TimeSeries getTimeSeries(Clock clock) {
            Point point;
            Object obj = this.ref != null ? this.ref.get() : null;
            double newValue = this.function.applyAsDouble(obj);
            PointWithFunction pointWithFunction = this;
            synchronized (pointWithFunction) {
                this.value = newValue > this.value ? newValue : this.value;
                point = Point.create((Value)Value.doubleValue((double)this.value), (Timestamp)clock.now());
            }
            return TimeSeries.createWithOnePoint(this.labelValues, (Point)point, (Timestamp)this.startTime);
        }
    }
}

