/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.jdbc.mvcc;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCountDownLatch;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.yardstick.IgniteAbstractBenchmark;
import org.apache.ignite.yardstick.jdbc.JdbcUtils;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public abstract class AbstractDistributedMvccBenchmark
extends IgniteAbstractBenchmark {
    public static final String UPDATE_QRY = "UPDATE test_long SET val = (val + 1) WHERE id BETWEEN ? AND ?";
    public static final long DATA_WAIT_TIMEOUT_MIN = 20L;
    protected int memberId;
    protected int driversNodesCnt;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.memberId = cfg.memberId();
        if (this.memberId < 0) {
            throw new IllegalStateException("Member id should be initialized with non-negative value");
        }
        this.driversNodesCnt = this.ignite().cluster().forClients().nodes().size();
        IgniteCountDownLatch dataIsReady = this.ignite().countDownLatch("fillDataLatch", 1, true, true);
        try {
            if (this.memberId == 0) {
                JdbcUtils.fillData(cfg, (IgniteEx)this.ignite(), this.args.range(), this.args.atomicMode());
                dataIsReady.countDown();
            } else {
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("No need to upload data for memberId=" + this.memberId + ". Just waiting"));
                dataIsReady.await(20L, TimeUnit.MINUTES);
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Data is ready.");
            }
        }
        catch (Throwable th) {
            dataIsReady.countDownAll();
            throw new RuntimeException("Fill Data failed.", th);
        }
        this.execute(new SqlFieldsQuery("SELECT COUNT(*) FROM test_long"));
    }

    protected List<List<?>> execute(SqlFieldsQuery qry) {
        return ((IgniteEx)this.ignite()).context().query().querySqlFields(qry, false).getAll();
    }
}

