/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.jdbc;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.yardstick.jdbc.AbstractNativeBenchmark;
import org.apache.ignite.yardstick.jdbc.DisjointRangeGenerator;
import org.yardstickframework.BenchmarkConfiguration;

public class NativeSqlUpdateRangeBenchmark
extends AbstractNativeBenchmark {
    private DisjointRangeGenerator idGen;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.idGen = new DisjointRangeGenerator(cfg.threads(), this.args.range(), this.args.sqlRange());
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        SqlFieldsQuery qry;
        long startId = this.idGen.nextRangeStartId();
        long endId = this.idGen.endRangeId(startId);
        long expRsSize = this.idGen.rangeWidth();
        if (this.idGen.rangeWidth() == 1L) {
            qry = new SqlFieldsQuery("UPDATE test_long SET val = (val + 1) WHERE id = ?");
            qry.setArgs(new Object[]{startId});
        } else {
            qry = new SqlFieldsQuery("UPDATE test_long SET val = (val + 1) WHERE id BETWEEN ? AND ?");
            qry.setArgs(new Object[]{startId, endId});
        }
        try (FieldsQueryCursor cursor = ((IgniteEx)this.ignite()).context().query().querySqlFields(qry, false);){
            Iterator it = cursor.iterator();
            List cntRow = (List)it.next();
            long rsSize = (Long)cntRow.get(0);
            if (it.hasNext()) {
                throw new Exception("Only one row expected on UPDATE query");
            }
            if (rsSize != expRsSize) {
                throw new Exception("Invalid result set size [actual=" + rsSize + ", expected=" + expRsSize + ']');
            }
        }
        return true;
    }
}

