/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionOptimisticException;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;

public class IgnitePutAllSerializableTxBenchmark
extends IgniteCacheAbstractBenchmark {
    private IgniteTransactions txs;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.txs = this.ignite().transactions();
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        IgniteCacheAbstractBenchmark.ThreadRange r = this.threadRange();
        HashMap<Integer, Integer> vals = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.args.batch(); ++i) {
            int key = r.nextRandom();
            vals.put(key, key);
        }
        IgniteCache cache = this.cacheForOperation();
        while (true) {
            try (Transaction tx = this.txs.txStart(TransactionConcurrency.OPTIMISTIC, TransactionIsolation.SERIALIZABLE);){
                cache.putAll(vals);
                tx.commit();
            }
            catch (TransactionOptimisticException e) {
                continue;
            }
            break;
        }
        return true;
    }

    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("tx");
    }
}

