/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.websession;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheException;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.websession.WebSession;
import org.apache.ignite.cache.websession.WebSessionListener;
import org.apache.ignite.cache.websession.WebSessionV2;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.websession.WebSessionAttributeProcessor;
import org.apache.ignite.internal.websession.WebSessionEntity;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public class WebSessionFilter
implements Filter {
    public static final String WEB_SES_NAME_PARAM = "IgniteWebSessionsGridName";
    public static final String WEB_SES_CACHE_NAME_PARAM = "IgniteWebSessionsCacheName";
    public static final String WEB_SES_MAX_RETRIES_ON_FAIL_NAME_PARAM = "IgniteWebSessionsMaximumRetriesOnFail";
    public static final String WEB_SES_RETRIES_TIMEOUT_NAME_PARAM = "IgniteWebSessionsRetriesTimeout";
    public static final String WEB_SES_KEEP_BINARY_PARAM = "IgniteWebSessionsKeepBinary";
    public static final int DFLT_MAX_RETRIES_ON_FAIL = 3;
    public static final int DFLT_RETRIES_ON_FAIL_TIMEOUT = 10000;
    public static final boolean DFLT_KEEP_BINARY_FLAG = true;
    private IgniteCache<String, WebSession> cache;
    private IgniteCache<String, WebSessionEntity> binaryCache;
    private IgniteTransactions txs;
    private IgniteLogger log;
    private ServletContext ctx;
    private IgniteClosure<String, String> sesIdTransformer;
    private boolean txEnabled;
    private Ignite webSesIgnite;
    private String cacheName;
    private int retries;
    private int retriesTimeout;
    private boolean keepBinary = true;
    private Marshaller marshaller;

    public void init(FilterConfig cfg) throws ServletException {
        this.ctx = cfg.getServletContext();
        String igniteInstanceName = (String)U.firstNotNull((Object[])new String[]{cfg.getInitParameter(WEB_SES_NAME_PARAM), this.ctx.getInitParameter(WEB_SES_NAME_PARAM)});
        this.cacheName = (String)U.firstNotNull((Object[])new String[]{cfg.getInitParameter(WEB_SES_CACHE_NAME_PARAM), this.ctx.getInitParameter(WEB_SES_CACHE_NAME_PARAM)});
        String retriesStr = (String)U.firstNotNull((Object[])new String[]{cfg.getInitParameter(WEB_SES_MAX_RETRIES_ON_FAIL_NAME_PARAM), this.ctx.getInitParameter(WEB_SES_MAX_RETRIES_ON_FAIL_NAME_PARAM)});
        try {
            this.retries = retriesStr != null ? Integer.parseInt(retriesStr) : 3;
        }
        catch (NumberFormatException e) {
            throw new IgniteException("Maximum number of retries parameter is invalid: " + retriesStr, (Throwable)e);
        }
        String retriesTimeoutStr = (String)U.firstNotNull((Object[])new String[]{cfg.getInitParameter(WEB_SES_RETRIES_TIMEOUT_NAME_PARAM), this.ctx.getInitParameter(WEB_SES_RETRIES_TIMEOUT_NAME_PARAM)});
        try {
            this.retriesTimeout = retriesTimeoutStr != null ? Integer.parseInt(retriesTimeoutStr) : 10000;
        }
        catch (NumberFormatException e) {
            throw new IgniteException("Retries timeout parameter is invalid: " + retriesTimeoutStr, (Throwable)e);
        }
        String binParam = cfg.getInitParameter(WEB_SES_KEEP_BINARY_PARAM);
        if (!F.isEmpty((String)binParam)) {
            this.keepBinary = Boolean.parseBoolean(binParam);
        }
        this.webSesIgnite = G.ignite((String)igniteInstanceName);
        if (this.webSesIgnite == null) {
            throw new IgniteException("Ignite instance for web sessions caching is not started (is it configured?): " + igniteInstanceName);
        }
        this.txs = this.webSesIgnite.transactions();
        this.log = this.webSesIgnite.log();
        this.marshaller = this.webSesIgnite.configuration().getMarshaller();
        this.initCache();
        String srvInfo = this.ctx.getServerInfo();
        if (srvInfo != null && srvInfo.contains("WebLogic")) {
            this.sesIdTransformer = new C1<String, String>(){

                public String apply(String s) {
                    int idx = s.indexOf(33);
                    if (idx < 0 || idx == s.length() - 1) {
                        return s;
                    }
                    if ((idx = s.indexOf(33, idx + 1)) < 0) {
                        return s;
                    }
                    return s.substring(0, idx);
                }
            };
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Started web sessions caching [igniteInstanceName=" + igniteInstanceName + ", cacheName=" + this.cacheName + ", maxRetriesOnFail=" + this.retries + ']');
        }
    }

    void initCache() {
        this.cache = this.webSesIgnite.cache(this.cacheName);
        this.binaryCache = this.webSesIgnite.cache(this.cacheName);
        if (this.cache == null) {
            throw new IgniteException("Cache for web sessions is not started (is it configured?): " + this.cacheName);
        }
        CacheConfiguration cacheCfg = (CacheConfiguration)this.cache.getConfiguration(CacheConfiguration.class);
        if (cacheCfg.getWriteSynchronizationMode() == CacheWriteSynchronizationMode.FULL_ASYNC) {
            throw new IgniteException("Cache for web sessions cannot be in FULL_ASYNC mode: " + this.cacheName);
        }
        if (!cacheCfg.isEagerTtl()) {
            throw new IgniteException("Cache for web sessions cannot operate with lazy TTL. Consider setting eagerTtl to true for cache: " + this.cacheName);
        }
        if (cacheCfg.getCacheMode() == CacheMode.PARTITIONED && cacheCfg.getAtomicityMode() != CacheAtomicityMode.ATOMIC) {
            U.quietAndWarn((IgniteLogger)this.webSesIgnite.log(), (Object)("Using " + cacheCfg.getAtomicityMode() + " atomicity for web sessions caching (switch to ATOMIC mode for better performance)"));
        }
        this.txEnabled = cacheCfg.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        block18: {
            assert (this.ctx != null);
            if (req instanceof HttpServletRequest) {
                HttpServletRequest httpReq = (HttpServletRequest)req;
                String sesId = null;
                try {
                    if (this.txEnabled) {
                        try (Transaction tx = this.txs.txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                            sesId = this.doFilterDispatch(httpReq, res, chain);
                            tx.commit();
                            break block18;
                        }
                    }
                    sesId = this.doFilterDispatch(httpReq, res, chain);
                }
                catch (Exception e) {
                    U.error((IgniteLogger)this.log, (Object)("Failed to update web session: " + sesId), (Throwable)e);
                }
            } else {
                chain.doFilter(req, res);
            }
        }
    }

    private String doFilterDispatch(HttpServletRequest httpReq, ServletResponse res, FilterChain chain) throws IOException, ServletException, CacheException {
        if (this.keepBinary) {
            return this.doFilterV2(httpReq, res, chain);
        }
        return this.doFilterV1(httpReq, res, chain);
    }

    private String doFilterV1(HttpServletRequest httpReq, ServletResponse res, FilterChain chain) throws IOException, ServletException, CacheException {
        Collection<T2<String, Object>> updates;
        WebSession cached = null;
        String sesId = httpReq.getSession(false) != null ? httpReq.getSession(false).getId() : httpReq.getRequestedSessionId();
        if (sesId != null) {
            sesId = this.transformSessionId(sesId);
            for (int i = 0; i < this.retries; ++i) {
                try {
                    cached = (WebSession)this.cache.get((Object)sesId);
                    break;
                }
                catch (IllegalStateException | CacheException | IgniteException e) {
                    this.handleLoadSessionException(sesId, i, (RuntimeException)e);
                    continue;
                }
            }
            if (cached != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Using cached session for ID: " + sesId);
                }
                if (cached.isNew()) {
                    cached = new WebSession(cached.getId(), cached, false);
                }
            } else {
                HttpSession ses;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cached session was invalidated and doesn't exist: " + sesId);
                }
                if ((ses = httpReq.getSession(false)) != null) {
                    try {
                        ses.invalidate();
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                }
                cached = this.createSession((HttpServletRequest)httpReq);
            }
        } else {
            cached = this.createSession((HttpServletRequest)httpReq);
        }
        assert (cached != null);
        sesId = cached.getId();
        cached.servletContext(this.ctx);
        cached.filter(this);
        cached.resetUpdates();
        cached.genSes(httpReq.getSession(false));
        httpReq = new RequestWrapper((HttpServletRequest)httpReq, cached);
        chain.doFilter((ServletRequest)httpReq, res);
        HttpSession ses = httpReq.getSession(false);
        if (ses != null && ses instanceof WebSession && (updates = ((WebSession)ses).updates()) != null) {
            this.updateAttributes(this.transformSessionId(sesId), updates, ses.getMaxInactiveInterval());
        }
        return sesId;
    }

    private String doFilterV2(HttpServletRequest httpReq, ServletResponse res, FilterChain chain) throws IOException, ServletException, CacheException {
        WebSessionV2 cached = null;
        String sesId = httpReq.getSession(false) != null ? httpReq.getSession(false).getId() : httpReq.getRequestedSessionId();
        if (sesId != null) {
            sesId = this.transformSessionId(sesId);
            for (int i = 0; i < this.retries; ++i) {
                try {
                    WebSessionEntity entity = (WebSessionEntity)this.binaryCache.get((Object)sesId);
                    if (entity == null) break;
                    cached = new WebSessionV2(sesId, httpReq.getSession(false), false, this.ctx, entity, this.marshaller);
                    break;
                }
                catch (IllegalStateException | CacheException | IgniteException e) {
                    this.handleLoadSessionException(sesId, i, (RuntimeException)e);
                    continue;
                }
            }
            if (cached != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Using cached session for ID: " + sesId);
                }
            } else {
                HttpSession ses;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cached session was invalidated and doesn't exist: " + sesId);
                }
                if ((ses = httpReq.getSession(false)) != null) {
                    try {
                        ses.invalidate();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                cached = this.createSessionV2((HttpServletRequest)httpReq);
            }
        } else {
            cached = this.createSessionV2((HttpServletRequest)httpReq);
        }
        assert (cached != null);
        sesId = cached.getId();
        httpReq = new RequestWrapperV2((HttpServletRequest)httpReq, cached);
        chain.doFilter((ServletRequest)httpReq, res);
        WebSessionV2 cachedNew = (WebSessionV2)httpReq.getSession(false);
        if (cachedNew != null && cachedNew.isValid()) {
            this.updateAttributesV2(cachedNew.getId(), cachedNew);
        }
        return sesId;
    }

    private void handleLoadSessionException(String sesId, int tryCnt, RuntimeException e) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(e.getMessage());
        }
        if (tryCnt == this.retries - 1) {
            throw new IgniteException("Failed to handle request [session= " + sesId + "]", (Throwable)e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Failed to handle request (will retry): " + sesId);
        }
        this.handleCacheOperationException(e);
    }

    private String transformSessionId(String sesId) {
        if (this.sesIdTransformer != null) {
            return (String)this.sesIdTransformer.apply((Object)sesId);
        }
        return sesId;
    }

    private WebSession createSession(HttpServletRequest httpReq) {
        HttpSession ses = httpReq.getSession(true);
        String sesId = this.transformSessionId(ses.getId());
        return this.createSession(ses, sesId);
    }

    private WebSession createSession(HttpSession ses, String sesId) {
        WebSession cached = new WebSession(sesId, ses, true);
        cached.genSes(ses);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Session created: " + sesId);
        }
        for (int i = 0; i < this.retries; ++i) {
            try {
                IgniteCache<String, WebSession> cache0 = this.cacheWithExpiryPolicy(cached.getMaxInactiveInterval(), this.cache);
                WebSession old = (WebSession)cache0.getAndPutIfAbsent((Object)sesId, (Object)cached);
                if (old == null || !(cached = old).isNew()) break;
                cached = new WebSession(cached.getId(), cached, false);
                break;
            }
            catch (IllegalStateException | CacheException | IgniteException e) {
                this.handleCreateSessionException(sesId, i, (RuntimeException)e);
                continue;
            }
        }
        return cached;
    }

    private void handleCreateSessionException(String sesId, int tryCnt, RuntimeException e) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(e.getMessage());
        }
        if (tryCnt == this.retries - 1) {
            throw new IgniteException("Failed to save session: " + sesId, (Throwable)e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Failed to save session (will retry): " + sesId);
        }
        this.handleCacheOperationException(e);
    }

    private WebSessionV2 createSessionV2(HttpSession ses, String sesId) throws IOException {
        assert (ses != null);
        assert (sesId != null);
        WebSessionV2 cached = new WebSessionV2(sesId, ses, true, this.ctx, null, this.marshaller);
        WebSessionEntity marshaledEntity = cached.marshalAttributes();
        for (int i = 0; i < this.retries; ++i) {
            try {
                IgniteCache<String, WebSessionEntity> cache0 = this.cacheWithExpiryPolicy(cached.getMaxInactiveInterval(), this.binaryCache);
                WebSessionEntity old = (WebSessionEntity)cache0.getAndPutIfAbsent((Object)sesId, (Object)marshaledEntity);
                if (old != null) {
                    cached = new WebSessionV2(sesId, ses, false, this.ctx, old, this.marshaller);
                    break;
                }
                cached = new WebSessionV2(sesId, ses, false, this.ctx, marshaledEntity, this.marshaller);
                break;
            }
            catch (IllegalStateException | CacheException | IgniteException e) {
                this.handleCreateSessionException(sesId, i, (RuntimeException)e);
                continue;
            }
        }
        return cached;
    }

    private WebSessionV2 createSessionV2(HttpServletRequest httpReq) throws IOException {
        HttpSession ses = httpReq.getSession(true);
        String sesId = this.transformSessionId(ses.getId());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Session created: " + sesId);
        }
        return this.createSessionV2(ses, sesId);
    }

    private <T> IgniteCache<String, T> cacheWithExpiryPolicy(int maxInactiveInteval, IgniteCache<String, T> cache) {
        if (maxInactiveInteval > 0) {
            long ttl = (long)maxInactiveInteval * 1000L;
            ModifiedExpiryPolicy plc = new ModifiedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, ttl));
            return cache.withExpiryPolicy((ExpiryPolicy)plc);
        }
        return cache;
    }

    public void destroySession(String sesId) {
        assert (sesId != null);
        for (int i = 0; i < this.retries; ++i) {
            try {
                if (!this.cache.remove((Object)sesId) || !this.log.isDebugEnabled()) continue;
                this.log.debug("Session destroyed: " + sesId);
                continue;
            }
            catch (IllegalStateException | CacheException | IgniteException e) {
                if (i == this.retries - 1) {
                    U.warn((IgniteLogger)this.log, (Object)("Failed to remove session [sesId=" + sesId + ", retries=" + this.retries + ']'));
                    continue;
                }
                U.warn((IgniteLogger)this.log, (Object)("Failed to remove session (will retry): " + sesId));
                this.handleCacheOperationException((Exception)e);
            }
        }
    }

    public void updateAttributes(String sesId, Collection<T2<String, Object>> updates, int maxInactiveInterval) {
        assert (sesId != null);
        assert (updates != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Session attributes updated [id=" + sesId + ", updates=" + updates + ']');
        }
        try {
            for (int i = 0; i < this.retries; ++i) {
                try {
                    IgniteCache<String, WebSession> cache0 = this.cacheWithExpiryPolicy(maxInactiveInterval, this.cache);
                    cache0.invoke((Object)sesId, WebSessionListener.newAttributeProcessor(updates), new Object[0]);
                    break;
                }
                catch (IllegalStateException | CacheException | IgniteException e) {
                    this.handleAttributeUpdateException(sesId, i, (RuntimeException)e);
                    continue;
                }
            }
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to update session attributes [id=" + sesId + ']'), (Throwable)e);
        }
    }

    public void updateAttributesV2(String sesId, WebSessionV2 ses) throws IOException {
        assert (sesId != null);
        assert (ses != null);
        Map<String, byte[]> updatesMap = ses.binaryUpdatesMap();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Session binary attributes updated [id=" + sesId + ", updates=" + updatesMap.keySet() + ']');
        }
        try {
            for (int i = 0; i < this.retries; ++i) {
                try {
                    IgniteCache<String, WebSessionEntity> cache0 = this.cacheWithExpiryPolicy(ses.getMaxInactiveInterval(), this.binaryCache);
                    cache0.invoke((Object)sesId, (EntryProcessor)new WebSessionAttributeProcessor(updatesMap.isEmpty() ? null : updatesMap, ses.getLastAccessedTime(), ses.getMaxInactiveInterval(), ses.isMaxInactiveIntervalChanged()), new Object[0]);
                    break;
                }
                catch (IllegalStateException | CacheException | IgniteException e) {
                    this.handleAttributeUpdateException(sesId, i, (RuntimeException)e);
                    continue;
                }
            }
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to update session V2 attributes [id=" + sesId + ']'), (Throwable)e);
        }
    }

    private void handleAttributeUpdateException(String sesId, int tryCnt, RuntimeException e) {
        if (tryCnt == this.retries - 1) {
            U.error((IgniteLogger)this.log, (Object)("Failed to apply updates for session (maximum number of retries exceeded) [sesId=" + sesId + ", retries=" + this.retries + ']'), (Throwable)e);
        } else {
            U.warn((IgniteLogger)this.log, (Object)("Failed to apply updates for session (will retry): " + sesId));
            this.handleCacheOperationException(e);
        }
    }

    void handleCacheOperationException(Exception e) {
        IgniteClientDisconnectedException cause;
        IgniteFuture retryFut = null;
        if (e instanceof IllegalStateException) {
            this.initCache();
            return;
        }
        if (X.hasCause((Throwable)e, (Class[])new Class[]{IgniteClientDisconnectedException.class})) {
            cause = (IgniteClientDisconnectedException)X.cause((Throwable)e, IgniteClientDisconnectedException.class);
            assert (cause != null) : e;
            retryFut = cause.reconnectFuture();
        } else if (X.hasCause((Throwable)e, (Class[])new Class[]{ClusterTopologyException.class})) {
            cause = (ClusterTopologyException)X.cause((Throwable)e, ClusterTopologyException.class);
            assert (cause != null) : e;
            retryFut = cause.retryReadyFuture();
        }
        if (retryFut != null) {
            try {
                retryFut.get((long)this.retriesTimeout);
            }
            catch (IgniteException retryErr) {
                throw new IgniteException("Failed to wait for retry: " + (Object)((Object)retryErr));
            }
        }
    }

    public String toString() {
        return S.toString(WebSessionFilter.class, (Object)this);
    }

    private class RequestWrapperV2
    extends HttpServletRequestWrapper {
        private WebSessionV2 ses;

        private RequestWrapperV2(HttpServletRequest req, WebSessionV2 ses) {
            super(req);
            assert (ses != null);
            this.ses = ses;
        }

        public HttpSession getSession(boolean create) {
            if (this.ses != null && !this.ses.isValid()) {
                WebSessionFilter.this.binaryCache.remove((Object)this.ses.id());
                if (create) {
                    try {
                        this.ses = WebSessionFilter.this.createSessionV2((HttpServletRequest)this.getRequest());
                    }
                    catch (IOException e) {
                        throw new IgniteException((Throwable)e);
                    }
                } else {
                    this.ses = null;
                }
            }
            return this.ses;
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        public String changeSessionId() {
            HttpServletRequest req = (HttpServletRequest)this.getRequest();
            String newId = req.changeSessionId();
            if (!F.eq((Object)newId, (Object)this.ses.getId())) {
                try {
                    this.ses = WebSessionFilter.this.createSessionV2(this.ses, newId);
                }
                catch (IOException e) {
                    throw new IgniteException((Throwable)e);
                }
            }
            return newId;
        }

        public void login(String username, String password) throws ServletException {
            HttpServletRequest req = (HttpServletRequest)this.getRequest();
            req.login(username, password);
            String newId = req.getSession(false).getId();
            if (!F.eq((Object)newId, (Object)this.ses.getId())) {
                try {
                    this.ses = WebSessionFilter.this.createSessionV2(this.ses, newId);
                }
                catch (IOException e) {
                    throw new IgniteException((Throwable)e);
                }
            }
        }

        public boolean isRequestedSessionIdValid() {
            return this.ses != null && this.ses.isValid();
        }
    }

    private class RequestWrapper
    extends HttpServletRequestWrapper {
        private volatile WebSession ses;

        private RequestWrapper(HttpServletRequest req, WebSession ses) {
            super(req);
            assert (ses != null);
            this.ses = ses;
        }

        public HttpSession getSession(boolean create) {
            if (!this.ses.isValid()) {
                if (create) {
                    this.ses = WebSessionFilter.this.createSession((HttpServletRequest)this.getRequest());
                    this.ses.servletContext(WebSessionFilter.this.ctx);
                    this.ses.filter(WebSessionFilter.this);
                    this.ses.resetUpdates();
                } else {
                    return null;
                }
            }
            return this.ses;
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        public String changeSessionId() {
            HttpServletRequest req = (HttpServletRequest)this.getRequest();
            String newId = req.changeSessionId();
            this.ses.setId(newId);
            this.ses = WebSessionFilter.this.createSession(this.ses, newId);
            this.ses.servletContext(WebSessionFilter.this.ctx);
            this.ses.filter(WebSessionFilter.this);
            this.ses.resetUpdates();
            return newId;
        }

        public void login(String username, String password) throws ServletException {
            HttpServletRequest req = (HttpServletRequest)this.getRequest();
            req.login(username, password);
            String newId = req.getSession(false).getId();
            this.ses.setId(newId);
            this.ses = WebSessionFilter.this.createSession(this.ses, newId);
            this.ses.servletContext(WebSessionFilter.this.ctx);
            this.ses.filter(WebSessionFilter.this);
            this.ses.resetUpdates();
        }

        public boolean isRequestedSessionIdValid() {
            return this.ses.isValid();
        }
    }
}

