/*
 * Decompiled with CFR 0.152.
 */
package org.yardstickframework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkDriver;
import org.yardstickframework.BenchmarkProbe;
import org.yardstickframework.BenchmarkUtils;
import org.yardstickframework.impl.BenchmarkLoader;
import org.yardstickframework.impl.BenchmarkProbeSet;
import org.yardstickframework.impl.BenchmarkRunner;

public class BenchmarkDriverStartUp {
    public static void main(String[] cmdArgs) throws Exception {
        final BenchmarkConfiguration cfg = new BenchmarkConfiguration();
        cfg.commandLineArguments(cmdArgs);
        BenchmarkUtils.jcommander(cmdArgs, cfg, "<benchmark-runner>");
        BenchmarkLoader ldr = new BenchmarkLoader();
        ldr.initialize(cfg);
        List<String> names = cfg.driverNames();
        if (names == null || names.isEmpty()) {
            BenchmarkUtils.errorHelp(cfg, "Driver class names are not specified.");
            return;
        }
        ArrayList<BenchmarkDriver> drivers = new ArrayList<BenchmarkDriver>();
        ArrayList<Integer> weights = new ArrayList<Integer>();
        HashSet<String> driverNames = new HashSet<String>();
        for (String nameWithWeight : names) {
            if ((nameWithWeight = nameWithWeight.trim()).isEmpty()) continue;
            String[] tokens = nameWithWeight.split(":");
            String name = tokens[0].trim();
            String weight = tokens.length == 1 ? "1" : tokens[1].trim();
            try {
                weights.add(Integer.parseInt(weight));
            }
            catch (NumberFormatException ignored) {
                BenchmarkUtils.errorHelp(cfg, "Can not parse driver run weight [driver=" + name + ", weight=" + weight + "]");
                return;
            }
            BenchmarkDriver drv = ldr.loadClass(BenchmarkDriver.class, name);
            if (drv == null) {
                BenchmarkUtils.errorHelp(cfg, "Could not find benchmark driver class name in classpath: " + name + ".\nMake sure class name is specified correctly and corresponding package is added " + "to -p argument list.");
                return;
            }
            drivers.add(drv);
            driverNames.add(name);
        }
        if (drivers.isEmpty()) {
            BenchmarkUtils.errorHelp(cfg, "Drivers are not found.");
            return;
        }
        if (driverNames.size() < drivers.size()) {
            BenchmarkUtils.errorHelp(cfg, "Multiple drivers with the same name are found.");
            return;
        }
        if (cfg.help()) {
            BenchmarkUtils.println(cfg, ((BenchmarkDriver)drivers.get(0)).usage());
            return;
        }
        BenchmarkProbeSet[] probeSets = new BenchmarkProbeSet[drivers.size()];
        try {
            for (int i = 0; i < drivers.size(); ++i) {
                Collection<BenchmarkProbe> probes = ldr.loadProbes();
                if (probes == null) {
                    probes = Collections.emptyList();
                }
                BenchmarkDriver drv = (BenchmarkDriver)drivers.get(i);
                probeSets[i] = new BenchmarkProbeSet(drv, cfg, probes, ldr);
                drv.setUp(cfg);
            }
        }
        catch (Throwable e) {
            BenchmarkUtils.error("Failed to set up benchmark drivers (will shutdown and exit).", e);
            for (BenchmarkDriver drv : drivers) {
                try {
                    drv.tearDown();
                }
                catch (Exception ex) {
                    BenchmarkUtils.println("Failed to tear down benchmark driver (will ignore) [drv=" + drv.description() + ", msg=" + ex.getMessage() + ']');
                }
            }
            return;
        }
        int[] weights0 = new int[weights.size()];
        for (int i = 0; i < weights.size(); ++i) {
            weights0[i] = (Integer)weights.get(i);
        }
        final BenchmarkRunner runner = new BenchmarkRunner(cfg, drivers.toArray(new BenchmarkDriver[drivers.size()]), probeSets, weights0);
        if (cfg.shutdownHook()) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        runner.cancel();
                    }
                    catch (Exception e) {
                        BenchmarkUtils.errorHelp(cfg, "Exception is raised during runner cancellation.", e);
                    }
                }
            });
        }
        runner.runBenchmark();
    }
}

