/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.transformations.SourceTransformation;
import org.apache.flink.streaming.api.transformations.StreamExchangeMode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecBoundedStreamScan;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecMultipleInput;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecExchange;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecUnion;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ExecNodeGraphProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ProcessorContext;
import org.apache.flink.table.planner.plan.nodes.exec.processor.utils.InputOrderCalculator;
import org.apache.flink.table.planner.plan.nodes.exec.processor.utils.InputPriorityConflictResolver;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecDataStreamScan;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecMultipleInput;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.visitor.AbstractExecNodeExactlyOnceVisitor;
import org.apache.flink.util.Preconditions;

public class MultipleInputNodeCreationProcessor
implements ExecNodeGraphProcessor {
    private final boolean isStreaming;

    public MultipleInputNodeCreationProcessor(boolean isStreaming) {
        this.isStreaming = isStreaming;
    }

    @Override
    public ExecNodeGraph process(ExecNodeGraph execGraph, ProcessorContext context) {
        if (!this.isStreaming) {
            InputPriorityConflictResolver resolver = new InputPriorityConflictResolver(execGraph.getRootNodes(), InputProperty.DamBehavior.BLOCKING, StreamExchangeMode.PIPELINED, (ReadableConfig)context.getPlanner().getTableConfig());
            resolver.detectAndResolve();
        }
        List<ExecNodeWrapper> rootWrappers = this.wrapExecNodes(execGraph.getRootNodes());
        List<ExecNodeWrapper> orderedWrappers = this.topologicalSort(rootWrappers);
        this.createMultipleInputGroups(orderedWrappers);
        this.optimizeMultipleInputGroups(orderedWrappers, context);
        List<ExecNode<?>> newRootNodes = this.createMultipleInputNodes((ReadableConfig)context.getPlanner().getTableConfig(), rootWrappers);
        return new ExecNodeGraph(newRootNodes);
    }

    private List<ExecNodeWrapper> wrapExecNodes(List<ExecNode<?>> rootNodes) {
        final HashMap wrapperMap = new HashMap();
        AbstractExecNodeExactlyOnceVisitor visitor = new AbstractExecNodeExactlyOnceVisitor(){

            @Override
            protected void visitNode(ExecNode<?> node) {
                ExecNodeWrapper wrapper = wrapperMap.computeIfAbsent(node, k -> new ExecNodeWrapper(node));
                for (ExecEdge inputEdge : node.getInputEdges()) {
                    ExecNode<?> inputNode = inputEdge.getSource();
                    ExecNodeWrapper inputWrapper = wrapperMap.computeIfAbsent(inputNode, k -> new ExecNodeWrapper(inputNode));
                    wrapper.inputs.add(inputWrapper);
                    inputWrapper.outputs.add(wrapper);
                }
                this.visitInputs(node);
            }
        };
        rootNodes.forEach(s2 -> s2.accept(visitor));
        ArrayList<ExecNodeWrapper> rootWrappers = new ArrayList<ExecNodeWrapper>();
        for (ExecNode<?> root : rootNodes) {
            ExecNodeWrapper rootWrapper = (ExecNodeWrapper)wrapperMap.get(root);
            Preconditions.checkNotNull((Object)rootWrapper, (String)"Root node is not wrapped. This is a bug.");
            rootWrappers.add(rootWrapper);
        }
        return rootWrappers;
    }

    private List<ExecNodeWrapper> topologicalSort(List<ExecNodeWrapper> rootWrappers) {
        ArrayList<ExecNodeWrapper> result = new ArrayList<ExecNodeWrapper>();
        LinkedList<ExecNodeWrapper> queue = new LinkedList<ExecNodeWrapper>(rootWrappers);
        HashMap<ExecNodeWrapper, Integer> visitCountMap = new HashMap<ExecNodeWrapper, Integer>();
        while (!queue.isEmpty()) {
            ExecNodeWrapper wrapper = (ExecNodeWrapper)queue.poll();
            result.add(wrapper);
            for (ExecNodeWrapper inputWrapper : wrapper.inputs) {
                int visitCount = visitCountMap.compute(inputWrapper, (k, v) -> v == null ? 1 : v + 1);
                if (visitCount != inputWrapper.outputs.size()) continue;
                queue.offer(inputWrapper);
            }
        }
        return result;
    }

    private void createMultipleInputGroups(List<ExecNodeWrapper> orderedWrappers) {
        for (ExecNodeWrapper wrapper : orderedWrappers) {
            if (!this.canBeMultipleInputNodeMember(wrapper)) continue;
            MultipleInputGroup outputGroup = this.canBeInSameGroupWithOutputs(wrapper);
            if (outputGroup != null) {
                outputGroup.addMember(wrapper);
                continue;
            }
            if (!this.canBeRootOfMultipleInputGroup(wrapper)) continue;
            wrapper.group = new MultipleInputGroup(wrapper);
        }
    }

    private boolean canBeMultipleInputNodeMember(ExecNodeWrapper wrapper) {
        if (wrapper.inputs.isEmpty()) {
            return false;
        }
        return !(wrapper.execNode instanceof CommonExecExchange);
    }

    private MultipleInputGroup canBeInSameGroupWithOutputs(ExecNodeWrapper wrapper) {
        if (wrapper.outputs.isEmpty()) {
            return null;
        }
        MultipleInputGroup outputGroup = ((ExecNodeWrapper)wrapper.outputs.get(0)).group;
        if (outputGroup == null) {
            return null;
        }
        for (ExecNodeWrapper outputWrapper : wrapper.outputs) {
            if (outputWrapper.group == outputGroup) continue;
            return null;
        }
        return outputGroup;
    }

    private boolean canBeRootOfMultipleInputGroup(ExecNodeWrapper wrapper) {
        return wrapper.inputs.size() >= 2;
    }

    private void optimizeMultipleInputGroups(List<ExecNodeWrapper> orderedWrappers, ProcessorContext context) {
        MultipleInputGroup group;
        for (int i = orderedWrappers.size() - 1; i >= 0; --i) {
            ExecNodeWrapper wrapper = orderedWrappers.get(i);
            group = wrapper.group;
            if (group == null || !this.isEntranceOfMultipleInputGroup(wrapper)) continue;
            boolean shouldRemove = false;
            if (wrapper.execNode instanceof CommonExecUnion) {
                shouldRemove = wrapper.inputs.stream().noneMatch(inputWrapper -> MultipleInputNodeCreationProcessor.isChainableSource(((ExecNodeWrapper)inputWrapper).execNode, context));
            } else if (wrapper.inputs.size() == 1) {
                ExecNode input = ((ExecNodeWrapper)wrapper.inputs.get(0)).execNode;
                boolean bl = shouldRemove = !(input instanceof CommonExecExchange) && !MultipleInputNodeCreationProcessor.isChainableSource(input, context);
            }
            if (!(shouldRemove |= wrapper.inputs.stream().anyMatch(inputWrapper -> ((ExecNodeWrapper)inputWrapper).execNode instanceof CommonExecExchange && ((ExecNodeWrapper)inputWrapper).execNode.getInputProperties().get(0).getRequiredDistribution().getType() == InputProperty.DistributionType.SINGLETON))) continue;
            wrapper.group.removeMember(wrapper);
        }
        for (ExecNodeWrapper wrapper : orderedWrappers) {
            group = wrapper.group;
            if (group == null || wrapper != wrapper.group.root) continue;
            boolean isUnion = wrapper.execNode instanceof CommonExecUnion;
            if (group.members.size() == 1) {
                if (!isUnion && !wrapper.inputs.stream().noneMatch(inputWrapper -> MultipleInputNodeCreationProcessor.isChainableSource(((ExecNodeWrapper)inputWrapper).execNode, context))) continue;
                wrapper.group.removeRoot();
                continue;
            }
            if (isUnion) {
                List sameGroupWrappers;
                int numberOfUsefulInputs = 0;
                ArrayList<Integer> uselessBranches = new ArrayList<Integer>();
                ArrayList<List> sameGroupWrappersList = new ArrayList<List>();
                for (int i = 0; i < wrapper.inputs.size(); ++i) {
                    ExecNodeWrapper inputWrapper2 = (ExecNodeWrapper)wrapper.inputs.get(i);
                    sameGroupWrappers = this.getInputWrappersInSameGroup(inputWrapper2, wrapper.group);
                    sameGroupWrappersList.add(sameGroupWrappers);
                    long numberOfValuableNodes = sameGroupWrappers.stream().filter(w -> ((ExecNodeWrapper)w).inputs.size() >= 2 && !(((ExecNodeWrapper)w).execNode instanceof CommonExecUnion)).count();
                    if (numberOfValuableNodes > 0L) {
                        ++numberOfUsefulInputs;
                        continue;
                    }
                    uselessBranches.add(i);
                }
                if (numberOfUsefulInputs >= 2) continue;
                Iterator iterator = uselessBranches.iterator();
                while (iterator.hasNext()) {
                    int branch = (Integer)iterator.next();
                    sameGroupWrappers = (List)sameGroupWrappersList.get(branch);
                    for (ExecNodeWrapper w2 : sameGroupWrappers) {
                        if (w2.group == null) continue;
                        w2.group.removeMember(w2);
                    }
                }
                wrapper.group.removeRoot();
                continue;
            }
            if (wrapper.inputs.size() != 1) continue;
            wrapper.group.removeRoot();
        }
    }

    private List<ExecNodeWrapper> getInputWrappersInSameGroup(ExecNodeWrapper wrapper, MultipleInputGroup group) {
        ArrayList<ExecNodeWrapper> ret = new ArrayList<ExecNodeWrapper>();
        LinkedList<ExecNodeWrapper> queue = new LinkedList<ExecNodeWrapper>();
        HashSet<ExecNodeWrapper> visited = new HashSet<ExecNodeWrapper>();
        queue.add(wrapper);
        visited.add(wrapper);
        while (!queue.isEmpty()) {
            ExecNodeWrapper w = (ExecNodeWrapper)queue.poll();
            if (w.group != group) continue;
            ret.add(w);
            for (ExecNodeWrapper inputWrapper : w.inputs) {
                if (visited.contains(inputWrapper)) continue;
                queue.add(inputWrapper);
                visited.add(inputWrapper);
            }
        }
        return ret;
    }

    private boolean isEntranceOfMultipleInputGroup(ExecNodeWrapper wrapper) {
        Preconditions.checkNotNull((Object)wrapper.group, (String)"Exec node wrapper does not have a multiple input group. This is a bug.");
        for (ExecNodeWrapper inputWrapper : wrapper.inputs) {
            if (inputWrapper.group != wrapper.group) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static boolean isChainableSource(ExecNode<?> node, ProcessorContext context) {
        if (node instanceof BatchExecBoundedStreamScan) {
            BatchExecBoundedStreamScan scan = (BatchExecBoundedStreamScan)node;
            return scan.getDataStream().getTransformation() instanceof SourceTransformation;
        }
        if (node instanceof StreamExecDataStreamScan) {
            StreamExecDataStreamScan scan = (StreamExecDataStreamScan)node;
            return scan.getDataStream().getTransformation() instanceof SourceTransformation;
        }
        if (node instanceof CommonExecTableSourceScan) {
            Transformation transformation = node.translateToPlan(((ProcessorContext)Preconditions.checkNotNull((Object)context)).getPlanner());
            return transformation instanceof SourceTransformation;
        }
        return false;
    }

    private List<ExecNode<?>> createMultipleInputNodes(ReadableConfig tableConfig, List<ExecNodeWrapper> rootWrappers) {
        ArrayList result = new ArrayList();
        HashMap visitedMap = new HashMap();
        for (ExecNodeWrapper rootWrapper : rootWrappers) {
            result.add(this.getMultipleInputNode(tableConfig, rootWrapper, visitedMap));
        }
        return result;
    }

    private ExecNode<?> getMultipleInputNode(ReadableConfig tableConfig, ExecNodeWrapper wrapper, Map<ExecNodeWrapper, ExecNode<?>> visitedMap) {
        if (visitedMap.containsKey(wrapper)) {
            return visitedMap.get(wrapper);
        }
        for (int i = 0; i < wrapper.inputs.size(); ++i) {
            ExecNode<?> multipleInputNode = this.getMultipleInputNode(tableConfig, (ExecNodeWrapper)wrapper.inputs.get(i), visitedMap);
            ExecEdge execEdge = ExecEdge.builder().source(multipleInputNode).target(wrapper.execNode).build();
            wrapper.execNode.replaceInputEdge(i, execEdge);
        }
        ExecNode<?> ret = wrapper.group != null && wrapper == wrapper.group.root ? this.createMultipleInputNode(tableConfig, wrapper.group, visitedMap) : wrapper.execNode;
        visitedMap.put(wrapper, ret);
        return ret;
    }

    private ExecNode<?> createMultipleInputNode(ReadableConfig tableConfig, MultipleInputGroup group, Map<ExecNodeWrapper, ExecNode<?>> visitedMap) {
        ArrayList inputs = new ArrayList();
        for (ExecNodeWrapper member : group.members) {
            for (int i = 0; i < member.inputs.size(); ++i) {
                ExecNodeWrapper memberInput = (ExecNodeWrapper)member.inputs.get(i);
                if (group.members.contains(memberInput)) continue;
                Preconditions.checkState((boolean)visitedMap.containsKey(memberInput), (Object)"Input of a multiple input member is not visited. This is a bug.");
                ExecNode<?> inputNode = visitedMap.get(memberInput);
                InputProperty inputProperty = member.execNode.getInputProperties().get(i);
                ExecEdge edge = member.execNode.getInputEdges().get(i);
                inputs.add(Tuple3.of(inputNode, (Object)inputProperty, (Object)edge));
            }
        }
        if (this.isStreaming) {
            return this.createStreamMultipleInputNode(tableConfig, group, inputs);
        }
        return this.createBatchMultipleInputNode(tableConfig, group, inputs);
    }

    private StreamExecMultipleInput createStreamMultipleInputNode(ReadableConfig tableConfig, MultipleInputGroup group, List<Tuple3<ExecNode<?>, InputProperty, ExecEdge>> inputs) {
        ExecNode rootNode = group.root.execNode;
        ArrayList inputNodes = new ArrayList();
        for (Tuple3<ExecNode<?>, InputProperty, ExecEdge> tuple3 : inputs) {
            inputNodes.add((ExecNode<?>)tuple3.f0);
        }
        String description = ExecNodeUtil.getMultipleInputDescription(rootNode, inputNodes, new ArrayList<InputProperty>());
        StreamExecMultipleInput multipleInput = new StreamExecMultipleInput(tableConfig, inputNodes.stream().map(i -> InputProperty.DEFAULT).collect(Collectors.toList()), rootNode, description);
        ArrayList<ExecEdge> inputEdges = new ArrayList<ExecEdge>(inputNodes.size());
        for (ExecNode execNode : inputNodes) {
            inputEdges.add(ExecEdge.builder().source(execNode).target(multipleInput).build());
        }
        multipleInput.setInputEdges(inputEdges);
        return multipleInput;
    }

    private BatchExecMultipleInput createBatchMultipleInputNode(ReadableConfig tableConfig, MultipleInputGroup group, List<Tuple3<ExecNode<?>, InputProperty, ExecEdge>> inputs) {
        HashSet inputSet = new HashSet();
        for (Tuple3<ExecNode<?>, InputProperty, ExecEdge> tuple3 : inputs) {
            inputSet.add((ExecNode<?>)tuple3.f0);
        }
        InputOrderCalculator calculator = new InputOrderCalculator(group.root.execNode, inputSet, InputProperty.DamBehavior.BLOCKING);
        Map<ExecNode<?>, Integer> inputOrderMap = calculator.calculate();
        ExecNode rootNode = group.root.execNode;
        ArrayList inputNodes = new ArrayList();
        ArrayList<InputProperty> inputProperties = new ArrayList<InputProperty>();
        ArrayList<ExecEdge> originalEdges = new ArrayList<ExecEdge>();
        for (Tuple3<ExecNode<?>, InputProperty, ExecEdge> tuple3 : inputs) {
            ExecNode inputNode = (ExecNode)tuple3.f0;
            InputProperty originalInputEdge = (InputProperty)tuple3.f1;
            ExecEdge execEdge = (ExecEdge)tuple3.f2;
            inputNodes.add(inputNode);
            inputProperties.add(InputProperty.builder().requiredDistribution(originalInputEdge.getRequiredDistribution()).damBehavior(originalInputEdge.getDamBehavior()).priority(inputOrderMap.get(inputNode)).build());
            originalEdges.add(execEdge);
        }
        String description = ExecNodeUtil.getMultipleInputDescription(rootNode, inputNodes, inputProperties);
        BatchExecMultipleInput multipleInput = new BatchExecMultipleInput(tableConfig, inputProperties, rootNode, originalEdges, description);
        ArrayList<ExecEdge> inputEdges = new ArrayList<ExecEdge>(inputNodes.size());
        for (ExecNode execNode : inputNodes) {
            inputEdges.add(ExecEdge.builder().source(execNode).target(multipleInput).build());
        }
        multipleInput.setInputEdges(inputEdges);
        return multipleInput;
    }

    private static class MultipleInputGroup {
        private final List<ExecNodeWrapper> members = new ArrayList<ExecNodeWrapper>();
        private ExecNodeWrapper root;

        private MultipleInputGroup(ExecNodeWrapper root) {
            this.members.add(root);
            this.root = root;
        }

        private void addMember(ExecNodeWrapper wrapper) {
            Preconditions.checkState((wrapper.group == null ? 1 : 0) != 0, (Object)"The given exec node wrapper is already in a multiple input group. This is a bug.");
            this.members.add(wrapper);
            wrapper.group = this;
        }

        private void removeMember(ExecNodeWrapper wrapper) {
            if (wrapper == this.root) {
                this.removeRoot();
            } else {
                Preconditions.checkState((boolean)this.members.remove(wrapper), (Object)"The given exec node wrapper does not exist in the multiple input group. This is a bug.");
                wrapper.group = null;
            }
        }

        private void removeRoot() {
            Preconditions.checkNotNull((Object)this.root, (String)"Multiple input group does not have a root. This is a bug.");
            HashSet<ExecNodeWrapper> sameGroupInputWrappers = new HashSet<ExecNodeWrapper>();
            for (ExecNodeWrapper inputWrapper : this.root.inputs) {
                if (!this.members.contains(inputWrapper)) continue;
                sameGroupInputWrappers.add(inputWrapper);
            }
            Preconditions.checkState((sameGroupInputWrappers.size() < 2 ? 1 : 0) != 0, (Object)"There are two or more inputs of the root remaining in the multiple input group. This is a bug.");
            this.members.remove(this.root);
            this.root.group = null;
            this.root = sameGroupInputWrappers.isEmpty() ? null : (ExecNodeWrapper)sameGroupInputWrappers.iterator().next();
        }
    }

    private static class ExecNodeWrapper {
        private final ExecNode<?> execNode;
        private final List<ExecNodeWrapper> inputs;
        private final List<ExecNodeWrapper> outputs;
        private MultipleInputGroup group;

        private ExecNodeWrapper(ExecNode<?> execNode) {
            this.execNode = execNode;
            this.inputs = new ArrayList<ExecNodeWrapper>();
            this.outputs = new ArrayList<ExecNodeWrapper>();
            this.group = null;
        }
    }
}

