/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBiVisitor;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDigestIncludeType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.runtime.GeoFunctions;
import org.apache.calcite.runtime.Geometries;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.CompositeList;
import org.apache.calcite.util.ConversionUtil;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.PolyNull;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.apache.flink.calcite.shaded.org.checkerframework.dataflow.qual.Pure;

public class RexLiteral
extends RexNode {
    private final @Nullable Comparable value;
    private final RelDataType type;
    private final SqlTypeName typeName;
    private static final ImmutableList<TimeUnit> TIME_UNITS = ImmutableList.copyOf(TimeUnit.values());

    RexLiteral(@Nullable Comparable value, RelDataType type, SqlTypeName typeName) {
        this.value = value;
        this.type = Objects.requireNonNull(type, "type");
        this.typeName = Objects.requireNonNull(typeName, "typeName");
        Preconditions.checkArgument(RexLiteral.valueMatchesType(value, typeName, true));
        Preconditions.checkArgument(value == null == type.isNullable());
        Preconditions.checkArgument(typeName != SqlTypeName.ANY);
        this.digest = this.computeDigest(RexDigestIncludeType.OPTIONAL);
    }

    @RequiresNonNull(value={"typeName", "type"})
    public final String computeDigest(@UnknownInitialization RexLiteral this, RexDigestIncludeType includeType) {
        if (includeType == RexDigestIncludeType.OPTIONAL) {
            if (this.digest != null) {
                return this.digest;
            }
            includeType = this.digestIncludesType();
        } else if (this.digest != null && includeType == this.digestIncludesType()) {
            return this.digest;
        }
        return RexLiteral.toJavaString(this.value, this.typeName, this.type, includeType);
    }

    @RequiresNonNull(value={"type"})
    RexDigestIncludeType digestIncludesType(@UnknownInitialization RexLiteral this) {
        return RexLiteral.shouldIncludeType(this.value, this.type);
    }

    public static boolean valueMatchesType(@Nullable Comparable value, SqlTypeName typeName, boolean strict) {
        if (value == null) {
            return true;
        }
        switch (typeName) {
            case BOOLEAN: {
                return value instanceof Boolean;
            }
            case NULL: {
                return false;
            }
            case INTEGER: 
            case TINYINT: 
            case SMALLINT: {
                if (strict) {
                    throw Util.unexpected(typeName);
                }
            }
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case REAL: 
            case BIGINT: {
                return value instanceof BigDecimal;
            }
            case DATE: {
                return value instanceof DateString;
            }
            case TIME: {
                return value instanceof TimeString;
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return value instanceof TimeString;
            }
            case TIMESTAMP: {
                return value instanceof TimestampString;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return value instanceof TimestampString;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return value instanceof BigDecimal;
            }
            case VARBINARY: {
                if (strict) {
                    throw Util.unexpected(typeName);
                }
            }
            case BINARY: {
                return value instanceof ByteString;
            }
            case VARCHAR: {
                if (strict) {
                    throw Util.unexpected(typeName);
                }
            }
            case CHAR: {
                return value instanceof NlsString && ((NlsString)value).getCharset() != null && ((NlsString)value).getCollation() != null;
            }
            case SARG: {
                return value instanceof Sarg;
            }
            case SYMBOL: {
                return value instanceof Enum;
            }
            case ROW: 
            case MULTISET: {
                return value instanceof List;
            }
            case GEOMETRY: {
                return value instanceof Geometries.Geom;
            }
            case ANY: {
                return false;
            }
        }
        throw Util.unexpected(typeName);
    }

    public static SqlTypeName strictTypeName(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        switch (typeName) {
            case INTEGER: 
            case TINYINT: 
            case SMALLINT: {
                return SqlTypeName.DECIMAL;
            }
            case FLOAT: 
            case REAL: {
                return SqlTypeName.DOUBLE;
            }
            case VARBINARY: {
                return SqlTypeName.BINARY;
            }
            case VARCHAR: {
                return SqlTypeName.CHAR;
            }
        }
        return typeName;
    }

    private static String toJavaString(@Nullable Comparable value, SqlTypeName typeName, RelDataType type, RexDigestIncludeType includeType) {
        assert (includeType != RexDigestIncludeType.OPTIONAL) : "toJavaString must not be called with includeType=OPTIONAL";
        if (value == null) {
            return includeType == RexDigestIncludeType.NO_TYPE ? "null" : "null:" + type.getFullTypeString();
        }
        StringBuilder sb = new StringBuilder();
        RexLiteral.appendAsJava(value, sb, typeName, type, false, includeType);
        if (includeType != RexDigestIncludeType.NO_TYPE) {
            sb.append(':');
            String fullTypeString = type.getFullTypeString();
            if (!fullTypeString.endsWith(" NOT NULL")) {
                sb.append(fullTypeString);
            } else {
                sb.append(fullTypeString, 0, fullTypeString.length() - " NOT NULL".length());
            }
        }
        return sb.toString();
    }

    private static RexDigestIncludeType shouldIncludeType(@Nullable Comparable value, RelDataType type) {
        NlsString nlsString;
        if (type.isNullable()) {
            return RexDigestIncludeType.ALWAYS;
        }
        RexDigestIncludeType includeType = type.getSqlTypeName() == SqlTypeName.BOOLEAN || type.getSqlTypeName() == SqlTypeName.INTEGER || type.getSqlTypeName() == SqlTypeName.SYMBOL ? RexDigestIncludeType.NO_TYPE : (type.getSqlTypeName() == SqlTypeName.CHAR && value instanceof NlsString ? (((nlsString = (NlsString)value).getCharset() != null && Objects.equals(type.getCharset(), nlsString.getCharset()) || nlsString.getCharset() == null && Objects.equals(SqlCollation.IMPLICIT.getCharset(), type.getCharset())) && Objects.equals(nlsString.getCollation(), type.getCollation()) && ((NlsString)value).getValue().length() == type.getPrecision() ? RexDigestIncludeType.NO_TYPE : RexDigestIncludeType.ALWAYS) : (type.getPrecision() == 0 && (type.getSqlTypeName() == SqlTypeName.TIME || type.getSqlTypeName() == SqlTypeName.TIMESTAMP || type.getSqlTypeName() == SqlTypeName.DATE) ? RexDigestIncludeType.NO_TYPE : RexDigestIncludeType.ALWAYS));
        return includeType;
    }

    public static boolean validConstant(@Nullable Object o, Litmus litmus) {
        if (o == null || o instanceof BigDecimal || o instanceof NlsString || o instanceof ByteString || o instanceof Boolean) {
            return litmus.succeed();
        }
        if (o instanceof List) {
            List list = (List)o;
            for (Object o1 : list) {
                if (RexLiteral.validConstant(o1, litmus)) continue;
                return litmus.fail("not a constant: {}", o1);
            }
            return litmus.succeed();
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            for (Map.Entry entry : map.entrySet()) {
                if (!RexLiteral.validConstant(entry.getKey(), litmus)) {
                    return litmus.fail("not a constant: {}", entry.getKey());
                }
                if (RexLiteral.validConstant(entry.getValue(), litmus)) continue;
                return litmus.fail("not a constant: {}", entry.getValue());
            }
            return litmus.succeed();
        }
        return litmus.fail("not a constant: {}", o);
    }

    private static List<TimeUnit> getTimeUnits(SqlTypeName typeName) {
        TimeUnit start = typeName.getStartUnit();
        TimeUnit end = typeName.getEndUnit();
        List list = TIME_UNITS.subList(start.ordinal(), end.ordinal() + 1);
        if (end == TimeUnit.SECOND) {
            return CompositeList.of(list, ImmutableList.of(TimeUnit.MILLISECOND));
        }
        return list;
    }

    private String intervalString(BigDecimal v) {
        List<TimeUnit> timeUnits = RexLiteral.getTimeUnits(this.type.getSqlTypeName());
        StringBuilder b = new StringBuilder();
        for (TimeUnit timeUnit : timeUnits) {
            BigDecimal[] result = v.divideAndRemainder(timeUnit.multiplier);
            if (b.length() > 0) {
                b.append(timeUnit.separator);
            }
            int width = b.length() == 0 ? -1 : RexLiteral.width(timeUnit);
            RexLiteral.pad(b, result[0].toString(), width);
            v = result[1];
        }
        if (Util.last(timeUnits) == TimeUnit.MILLISECOND) {
            while (b.toString().matches(".*\\.[0-9]*0")) {
                if (b.toString().endsWith(".0")) {
                    b.setLength(b.length() - 2);
                    continue;
                }
                b.setLength(b.length() - 1);
            }
        }
        return b.toString();
    }

    private static void pad(StringBuilder b, String s2, int width) {
        if (width >= 0) {
            for (int i = s2.length(); i < width; ++i) {
                b.append('0');
            }
        }
        b.append(s2);
    }

    private static int width(TimeUnit timeUnit) {
        switch (timeUnit) {
            case MILLISECOND: {
                return 3;
            }
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                return 2;
            }
        }
        return -1;
    }

    public void printAsJava(PrintWriter pw) {
        Util.asStringBuilder(pw, sb -> RexLiteral.appendAsJava(this.value, sb, this.typeName, this.type, true, RexDigestIncludeType.NO_TYPE));
    }

    private static void appendAsJava(@Nullable Comparable value, StringBuilder sb, SqlTypeName typeName, RelDataType type, boolean java, RexDigestIncludeType includeType) {
        switch (typeName) {
            case CHAR: {
                NlsString nlsString = (NlsString)Nullness.castNonNull(value);
                if (java) {
                    Util.printJavaString(sb, nlsString.getValue(), true);
                    break;
                }
                boolean includeCharset = nlsString.getCharsetName() != null && !nlsString.getCharsetName().equals(CalciteSystemProperty.DEFAULT_CHARSET.value());
                sb.append(nlsString.asSql(includeCharset, false));
                break;
            }
            case BOOLEAN: {
                assert (value instanceof Boolean);
                sb.append(value.toString());
                break;
            }
            case DECIMAL: {
                assert (value instanceof BigDecimal);
                sb.append(value.toString());
                break;
            }
            case DOUBLE: {
                assert (value instanceof BigDecimal);
                sb.append(Util.toScientificNotation((BigDecimal)value));
                break;
            }
            case BIGINT: {
                assert (value instanceof BigDecimal);
                long narrowLong = ((BigDecimal)value).longValue();
                sb.append(String.valueOf(narrowLong));
                sb.append('L');
                break;
            }
            case BINARY: {
                assert (value instanceof ByteString);
                sb.append("X'");
                sb.append(((ByteString)value).toString(16));
                sb.append("'");
                break;
            }
            case NULL: {
                assert (value == null);
                sb.append("null");
                break;
            }
            case SARG: {
                assert (value instanceof Sarg);
                Util.asStringBuilder(sb, sb2 -> RexLiteral.printSarg(sb2, (Sarg)value, type));
                break;
            }
            case SYMBOL: {
                assert (value instanceof Enum);
                sb.append("FLAG(");
                sb.append(value.toString());
                sb.append(")");
                break;
            }
            case DATE: {
                assert (value instanceof DateString);
                sb.append(value.toString());
                break;
            }
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: {
                assert (value instanceof TimeString);
                sb.append(value.toString());
                break;
            }
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                assert (value instanceof TimestampString);
                sb.append(value.toString());
                break;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                assert (value instanceof BigDecimal);
                sb.append(value.toString());
                break;
            }
            case ROW: 
            case MULTISET: {
                assert (value instanceof List) : "value must implement List: " + value;
                List list = (List)((Object)Nullness.castNonNull(value));
                Util.asStringBuilder(sb, sb2 -> Util.printList(sb, list.size(), (sb3, i) -> sb3.append(((RexLiteral)list.get(i)).computeDigest(includeType))));
                break;
            }
            case GEOMETRY: {
                String wkt = GeoFunctions.ST_AsWKT((Geometries.Geom)Nullness.castNonNull(value));
                sb.append(wkt);
                break;
            }
            default: {
                assert (RexLiteral.valueMatchesType(value, typeName, true));
                throw Util.needToImplement((Object)typeName);
            }
        }
    }

    private static <C extends Comparable<C>> void printSarg(StringBuilder sb, Sarg<C> sarg, RelDataType type) {
        sarg.printTo(sb, (sb2, value) -> sb2.append(RexLiteral.toLiteral(type, value)));
    }

    private static RexLiteral toLiteral(RelDataType type, Comparable<?> value) {
        SqlTypeName typeName = RexLiteral.strictTypeName(type);
        switch (typeName) {
            case ROW: {
                assert (value instanceof List) : "value must implement List: " + value;
                List fieldValues = (List)((Object)value);
                List<RelDataTypeField> fields = type.getFieldList();
                List<RexLiteral> fieldLiterals = FlatLists.of(Functions.generate(fieldValues.size(), i -> RexLiteral.toLiteral(((RelDataTypeField)fields.get(i)).getType(), (Comparable)fieldValues.get(i))));
                return new RexLiteral((Comparable)((Object)fieldLiterals), type, typeName);
            }
            case MULTISET: {
                assert (value instanceof List) : "value must implement List: " + value;
                List elementValues = (List)((Object)value);
                List<RexLiteral> elementLiterals = FlatLists.of(Functions.generate(elementValues.size(), i -> RexLiteral.toLiteral(Nullness.castNonNull(type.getComponentType()), (Comparable)elementValues.get(i))));
                return new RexLiteral((Comparable)((Object)elementLiterals), type, typeName);
            }
        }
        return new RexLiteral(value, type, typeName);
    }

    public static @PolyNull RexLiteral fromJdbcString(RelDataType type, SqlTypeName typeName, @PolyNull String literal) {
        if (literal == null) {
            return null;
        }
        switch (typeName) {
            case CHAR: {
                Charset charset = Objects.requireNonNull(type.getCharset(), () -> "charset for " + type);
                SqlCollation collation = type.getCollation();
                NlsString str = new NlsString(literal, charset.name(), collation);
                return new RexLiteral(str, type, typeName);
            }
            case BOOLEAN: {
                Boolean b = ConversionUtil.toBoolean(literal);
                return new RexLiteral(b, type, typeName);
            }
            case DECIMAL: 
            case DOUBLE: {
                BigDecimal d = new BigDecimal(literal);
                return new RexLiteral(d, type, typeName);
            }
            case BINARY: {
                byte[] bytes = ConversionUtil.toByteArrayFromString(literal, 16);
                return new RexLiteral(new ByteString(bytes), type, typeName);
            }
            case NULL: {
                return new RexLiteral(null, type, typeName);
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                long millis = SqlParserUtil.intervalToMillis(literal, Nullness.castNonNull(type.getIntervalQualifier()));
                return new RexLiteral(BigDecimal.valueOf(millis), type, typeName);
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                long months = SqlParserUtil.intervalToMonths(literal, Nullness.castNonNull(type.getIntervalQualifier()));
                return new RexLiteral(BigDecimal.valueOf(months), type, typeName);
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                Comparable<DateString> v;
                String format = RexLiteral.getCalendarFormat(typeName);
                TimeZone tz = DateTimeUtils.UTC_ZONE;
                block10 : switch (typeName) {
                    case DATE: {
                        Calendar cal = DateTimeUtils.parseDateFormat(literal, new SimpleDateFormat(format, Locale.ROOT), tz);
                        if (cal == null) {
                            throw new AssertionError((Object)("fromJdbcString: invalid date/time value '" + literal + "'"));
                        }
                        v = DateString.fromCalendarFields(cal);
                        break;
                    }
                    default: {
                        assert (format != null);
                        DateTimeUtils.PrecisionTime ts = DateTimeUtils.parsePrecisionDateTimeLiteral(literal, new SimpleDateFormat(format, Locale.ROOT), tz, -1);
                        if (ts == null) {
                            throw new AssertionError((Object)("fromJdbcString: invalid date/time value '" + literal + "'"));
                        }
                        switch (typeName) {
                            case TIMESTAMP: {
                                v = TimestampString.fromCalendarFields(ts.getCalendar()).withFraction(ts.getFraction());
                                break block10;
                            }
                            case TIME: {
                                v = TimeString.fromCalendarFields(ts.getCalendar()).withFraction(ts.getFraction());
                                break block10;
                            }
                        }
                        throw new AssertionError();
                    }
                }
                return new RexLiteral(v, type, typeName);
            }
        }
        throw new AssertionError((Object)"fromJdbcString: unsupported type");
    }

    private static String getCalendarFormat(SqlTypeName typeName) {
        switch (typeName) {
            case DATE: {
                return "yyyy-MM-dd";
            }
            case TIME: {
                return "HH:mm:ss";
            }
            case TIMESTAMP: {
                return "yyyy-MM-dd HH:mm:ss";
            }
        }
        throw new AssertionError((Object)"getCalendarFormat: unknown type");
    }

    public SqlTypeName getTypeName() {
        return this.typeName;
    }

    @Override
    public RelDataType getType() {
        return this.type;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.LITERAL;
    }

    public boolean isNull() {
        return this.value == null;
    }

    @Pure
    public @Nullable Comparable getValue() {
        assert (RexLiteral.valueMatchesType(this.value, this.typeName, true)) : this.value;
        if (this.value == null) {
            return null;
        }
        switch (this.typeName) {
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return this.getValueAs(Calendar.class);
            }
        }
        return this.value;
    }

    public @Nullable Object getValue2() {
        if (this.value == null) {
            return null;
        }
        switch (this.typeName) {
            case CHAR: {
                return this.getValueAs(String.class);
            }
            case DECIMAL: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.getValueAs(Long.class);
            }
            case DATE: 
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return this.getValueAs(Integer.class);
            }
        }
        return this.value;
    }

    public @Nullable Object getValue3() {
        if (this.value == null) {
            return null;
        }
        switch (this.typeName) {
            case DECIMAL: {
                assert (this.value instanceof BigDecimal);
                return this.value;
            }
        }
        return this.getValue2();
    }

    public @Nullable Comparable getValue4() {
        if (this.value == null) {
            return null;
        }
        switch (this.typeName) {
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.getValueAs(Long.class);
            }
            case DATE: 
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return this.getValueAs(Integer.class);
            }
        }
        return this.value;
    }

    public <T> @Nullable T getValueAs(Class<T> clazz) {
        if (this.value == null || clazz.isInstance(this.value)) {
            return clazz.cast(this.value);
        }
        switch (this.typeName) {
            case BINARY: {
                if (clazz != byte[].class) break;
                return clazz.cast(((ByteString)this.value).getBytes());
            }
            case CHAR: {
                if (clazz == String.class) {
                    return clazz.cast(((NlsString)this.value).getValue());
                }
                if (clazz != Character.class) break;
                return clazz.cast(Character.valueOf(((NlsString)this.value).getValue().charAt(0)));
            }
            case VARCHAR: {
                if (clazz != String.class) break;
                return clazz.cast(((NlsString)this.value).getValue());
            }
            case DECIMAL: {
                if (clazz == Long.class) {
                    return clazz.cast(((BigDecimal)this.value).unscaledValue().longValue());
                }
            }
            case INTEGER: 
            case TINYINT: 
            case SMALLINT: 
            case DOUBLE: 
            case FLOAT: 
            case REAL: 
            case BIGINT: {
                if (clazz == Long.class) {
                    return clazz.cast(((BigDecimal)this.value).longValue());
                }
                if (clazz == Integer.class) {
                    return clazz.cast(((BigDecimal)this.value).intValue());
                }
                if (clazz == Short.class) {
                    return clazz.cast(((BigDecimal)this.value).shortValue());
                }
                if (clazz == Byte.class) {
                    return clazz.cast(((BigDecimal)this.value).byteValue());
                }
                if (clazz == Double.class) {
                    return clazz.cast(((BigDecimal)this.value).doubleValue());
                }
                if (clazz != Float.class) break;
                return clazz.cast(Float.valueOf(((BigDecimal)this.value).floatValue()));
            }
            case DATE: {
                if (clazz == Integer.class) {
                    return clazz.cast(((DateString)this.value).getDaysSinceEpoch());
                }
                if (clazz != Calendar.class) break;
                return clazz.cast(((DateString)this.value).toCalendar());
            }
            case TIME: {
                if (clazz == Integer.class) {
                    return clazz.cast(((TimeString)this.value).getMillisOfDay());
                }
                if (clazz != Calendar.class) break;
                return clazz.cast(((TimeString)this.value).toCalendar());
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                if (clazz != Integer.class) break;
                return clazz.cast(((TimeString)this.value).getMillisOfDay());
            }
            case TIMESTAMP: {
                if (clazz == Long.class) {
                    return clazz.cast(((TimestampString)this.value).getMillisSinceEpoch());
                }
                if (clazz != Calendar.class) break;
                return clazz.cast(((TimestampString)this.value).toCalendar());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                if (clazz == Long.class) {
                    return clazz.cast(((TimestampString)this.value).getMillisSinceEpoch());
                }
                if (clazz != Calendar.class) break;
                return clazz.cast(((TimestampString)this.value).toCalendar());
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                if (clazz == Integer.class) {
                    return clazz.cast(((BigDecimal)this.value).intValue());
                }
                if (clazz == Long.class) {
                    return clazz.cast(((BigDecimal)this.value).longValue());
                }
                if (clazz == String.class) {
                    return clazz.cast(this.intervalString(Nullness.castNonNull(this.getValueAs(BigDecimal.class)).abs()));
                }
                if (clazz != Boolean.class) break;
                return clazz.cast(Nullness.castNonNull(this.getValueAs(BigDecimal.class)).signum() < 0);
            }
        }
        throw new AssertionError((Object)("cannot convert " + (Object)((Object)this.typeName) + " literal to " + clazz));
    }

    public static boolean booleanValue(RexNode node) {
        return (Boolean)Nullness.castNonNull(((RexLiteral)node).value);
    }

    @Override
    public boolean isAlwaysTrue() {
        if (this.typeName != SqlTypeName.BOOLEAN) {
            return false;
        }
        return RexLiteral.booleanValue(this);
    }

    @Override
    public boolean isAlwaysFalse() {
        if (this.typeName != SqlTypeName.BOOLEAN) {
            return false;
        }
        return !RexLiteral.booleanValue(this);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof RexLiteral && Objects.equals(((RexLiteral)obj).value, this.value) && Objects.equals(((RexLiteral)obj).type, this.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.type);
    }

    public static @Nullable Comparable value(RexNode node) {
        return RexLiteral.findValue(node);
    }

    public static int intValue(RexNode node) {
        Comparable value = Nullness.castNonNull(RexLiteral.findValue(node));
        return ((Number)((Object)value)).intValue();
    }

    public static @Nullable String stringValue(RexNode node) {
        Comparable value = RexLiteral.findValue(node);
        return value == null ? null : ((NlsString)value).getValue();
    }

    private static @Nullable Comparable findValue(RexNode node) {
        if (node instanceof RexLiteral) {
            return ((RexLiteral)node).value;
        }
        if (node instanceof RexCall) {
            RexCall call = (RexCall)node;
            SqlOperator operator = call.getOperator();
            if (operator == SqlStdOperatorTable.CAST) {
                return RexLiteral.findValue(call.getOperands().get(0));
            }
            if (operator == SqlStdOperatorTable.UNARY_MINUS) {
                BigDecimal value = (BigDecimal)RexLiteral.findValue(call.getOperands().get(0));
                return Objects.requireNonNull(value, () -> "can't negate null in " + node).negate();
            }
        }
        throw new AssertionError((Object)("not a literal: " + node));
    }

    public static boolean isNullLiteral(RexNode node) {
        return node instanceof RexLiteral && ((RexLiteral)node).value == null;
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitLiteral(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitLiteral(this, arg);
    }
}

