/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.common.flogger.GoogleLogger;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;

class GoogleHadoopOutputStream
extends OutputStream {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private WritableByteChannel channel;
    private OutputStream out;
    private final URI gcsPath;
    private final FileSystem.Statistics statistics;

    GoogleHadoopOutputStream(GoogleHadoopFileSystemBase ghfs, URI gcsPath, FileSystem.Statistics statistics, CreateFileOptions createFileOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("GoogleHadoopOutputStream(gcsPath: %s, createFileOptions: %s)", (Object)gcsPath, (Object)createFileOptions);
        this.gcsPath = gcsPath;
        this.statistics = statistics;
        GoogleCloudStorageFileSystem gcsfs = ghfs.getGcsFs();
        this.channel = GoogleHadoopOutputStream.createChannel(gcsfs, gcsPath, createFileOptions);
        this.out = GoogleHadoopOutputStream.createOutputStream(this.channel, gcsfs.getOptions().getCloudStorageOptions());
    }

    private static WritableByteChannel createChannel(GoogleCloudStorageFileSystem gcsfs, URI gcsPath, CreateFileOptions options) throws IOException {
        try {
            return gcsfs.create(gcsPath, options);
        }
        catch (java.nio.file.FileAlreadyExistsException e) {
            throw (FileAlreadyExistsException)new FileAlreadyExistsException(String.format("'%s' already exists", gcsPath)).initCause(e);
        }
    }

    private static OutputStream createOutputStream(WritableByteChannel channel, GoogleCloudStorageOptions gcsOptions) {
        OutputStream out = Channels.newOutputStream(channel);
        int bufferSize = gcsOptions.getWriteChannelOptions().getBufferSize();
        return bufferSize > 0 ? new BufferedOutputStream(out, bufferSize) : out;
    }

    @Override
    public void write(int b) throws IOException {
        this.throwIfNotOpen();
        this.out.write(b);
        this.statistics.incrementBytesWritten(1L);
        this.statistics.incrementWriteOps(1);
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        this.throwIfNotOpen();
        this.out.write(b, offset, len);
        this.statistics.incrementBytesWritten(len);
        this.statistics.incrementWriteOps(1);
    }

    @Override
    public void close() throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("close(%s)", this.gcsPath);
        if (this.out != null) {
            try {
                this.out.close();
            }
            finally {
                this.out = null;
                this.channel = null;
            }
        }
    }

    private boolean isOpen() {
        return this.out != null;
    }

    private void throwIfNotOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    WritableByteChannel getInternalChannel() {
        return this.channel;
    }
}

