/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.RestSerializationException;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TypeRegistry;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

@BetaApi
public class ProtoRestSerializer<RequestT extends Message> {
    private final TypeRegistry registry;

    private ProtoRestSerializer(TypeRegistry registry) {
        this.registry = registry;
    }

    public static <RequestT extends Message> ProtoRestSerializer<RequestT> create() {
        return ProtoRestSerializer.create(TypeRegistry.getEmptyTypeRegistry());
    }

    static <RequestT extends Message> ProtoRestSerializer<RequestT> create(TypeRegistry registry) {
        return new ProtoRestSerializer<RequestT>(registry);
    }

    String toJson(RequestT message) {
        try {
            return JsonFormat.printer().usingTypeRegistry(this.registry).print((MessageOrBuilder)message);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RestSerializationException("Failed to serialize message to JSON", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    RequestT fromJson(InputStream message, Charset messageCharset, Message.Builder builder) {
        try (InputStreamReader json = new InputStreamReader(message, messageCharset);){
            JsonFormat.parser().usingTypeRegistry(this.registry).ignoringUnknownFields().merge(json, builder);
            Message message2 = builder.build();
            return (RequestT)message2;
        }
        catch (IOException e) {
            throw new RestSerializationException("Failed to parse response message", e);
        }
    }

    public void putPathParam(Map<String, String> fields, String fieldName, Object fieldValue) {
        fields.put(fieldName, String.valueOf(fieldValue));
    }

    public void putQueryParam(Map<String, List<String>> fields, String fieldName, Object fieldValue) {
        ImmutableList.Builder paramValueList = ImmutableList.builder();
        if (fieldValue instanceof List) {
            for (Object fieldValueItem : (List)fieldValue) {
                paramValueList.add(String.valueOf(fieldValueItem));
            }
        } else {
            paramValueList.add(String.valueOf(fieldValue));
        }
        fields.put(fieldName, (List<String>)((Object)paramValueList.build()));
    }

    public String toBody(String fieldName, RequestT fieldValue) {
        return this.toJson(fieldValue);
    }
}

