/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.sourceeditor;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.contentassist.ComboContentAssistSubjectAdapter;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.contentassist.TextContentAssistSubjectAdapter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class DialogContentAssistant
extends SubjectControlContentAssistant
implements FocusListener {
    private Control control;
    private IHandlerActivation handlerActivation;
    private boolean possibleCompletionsVisible = false;

    public void install(Text text) {
        this.control = text;
        this.control.addFocusListener((FocusListener)this);
        super.install((IContentAssistSubjectControl)new TextContentAssistSubjectAdapter(text));
    }

    public void install(Combo combo) {
        this.control = combo;
        this.control.addFocusListener((FocusListener)this);
        super.install((IContentAssistSubjectControl)new ComboContentAssistSubjectAdapter(combo));
    }

    public void install(ITextViewer viewer) {
        this.control = viewer.getTextWidget();
        this.control.addFocusListener((FocusListener)this);
        this.control.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (DialogContentAssistant.this.possibleCompletionsVisible) {
                    e.doit = false;
                }
            }
        });
        super.install(viewer);
    }

    public void uninstall() {
        if (this.handlerActivation != null) {
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
            handlerService.deactivateHandler(this.handlerActivation);
            this.handlerActivation = null;
        }
        if (this.control != null) {
            this.control.removeFocusListener((FocusListener)this);
        }
        super.uninstall();
    }

    protected Point restoreCompletionProposalPopupSize() {
        this.possibleCompletionsVisible = true;
        return super.restoreCompletionProposalPopupSize();
    }

    public String showPossibleCompletions() {
        this.possibleCompletionsVisible = true;
        return super.showPossibleCompletions();
    }

    protected void possibleCompletionsClosed() {
        this.possibleCompletionsVisible = false;
        super.possibleCompletionsClosed();
    }

    public void focusGained(FocusEvent e) {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
        if (handlerService != null) {
            AbstractHandler handler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    DialogContentAssistant.this.showPossibleCompletions();
                    return null;
                }
            };
            this.handlerActivation = handlerService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)handler);
        }
    }

    public void focusLost(FocusEvent e) {
        if (this.handlerActivation != null) {
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
            handlerService.deactivateHandler(this.handlerActivation);
            this.handlerActivation = null;
        }
    }
}

