/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.searchRequest.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.codec.search.SubstringFilter;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreAny
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreAny.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreAny() {
        super("Store a any value");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator decorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        SubstringFilter substringFilter = (SubstringFilter)decorator.getTerminalFilter();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_04019, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        String any = Strings.utf8ToString((byte[])tlv.getValue().getData());
        substringFilter.addAnySubstrings(any);
        decorator.unstackFilters((Asn1Container)container);
        if (IS_DEBUG) {
            LOG.debug("Stored a any substring : {}", (Object)any);
        }
    }
}

