/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.cache.SoftRefFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.provider.tar.TarFileProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LargeTarTestCase {
    private static final String baseDir = "target/test-classes/test-data/";
    private static final String largeFilePath = "target/test-classes/test-data/";
    private static final String largeFileName = "largefile";
    private DefaultFileSystemManager manager;

    protected void createLargeFile(String path, final String name) throws Exception {
        long _1K = 1024L;
        long _1M = 0x100000L;
        long _1G = 0x40000000L;
        long fileSize = 0xC0000000L;
        File tarGzFile = new File(path + name + ".tar.gz");
        if (!tarGzFile.exists()) {
            System.out.println("This test is a bit slow. It needs to write 3GB of data as a compressed file (approx. 3MB) to your hard drive");
            final PipedOutputStream outTarFileStream = new PipedOutputStream();
            PipedInputStream inTarFileStream = new PipedInputStream(outTarFileStream);
            Thread source = new Thread(){

                @Override
                public void run() {
                    byte[] ba_1k = new byte[1024];
                    Arrays.fill(ba_1k, (byte)97);
                    try {
                        TarArchiveOutputStream outTarStream = (TarArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("tar", (OutputStream)outTarFileStream);
                        TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(name + ".txt");
                        tarArchiveEntry.setSize(0xC0000000L);
                        outTarStream.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
                        for (long i = 0L; i < 0xC0000000L; i += (long)ba_1k.length) {
                            outTarStream.write(ba_1k);
                        }
                        outTarStream.closeArchiveEntry();
                        outTarStream.close();
                        outTarFileStream.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            source.start();
            File gzFile = new File(path + name + ".tar.gz");
            OutputStream outGzipFileStream = Files.newOutputStream(gzFile.toPath(), new OpenOption[0]);
            GzipCompressorOutputStream outGzipStream = (GzipCompressorOutputStream)new CompressorStreamFactory().createCompressorOutputStream("gz", outGzipFileStream);
            IOUtils.copy((InputStream)inTarFileStream, (OutputStream)outGzipStream);
            inTarFileStream.close();
            outGzipStream.close();
            outGzipFileStream.close();
        }
    }

    protected boolean endsWith(String testString, String[] testList) {
        for (String string : testList) {
            if (!testString.endsWith(string)) continue;
            return true;
        }
        return false;
    }

    protected void fileCheck(String[] expectedFiles, String tarFile) throws Exception {
        Assert.assertNotNull((Object)this.manager);
        FileObject file = this.manager.resolveFile(tarFile);
        Assert.assertNotNull((Object)file);
        List<FileObject> files = Arrays.asList(file.getChildren());
        Assert.assertNotNull(files);
        for (String expectedFile : expectedFiles) {
            Assert.assertTrue((String)("Expected file not found: " + expectedFile), (boolean)this.fileExists(expectedFile, files));
        }
    }

    protected boolean fileExists(String expectedFile, List<FileObject> files) {
        for (FileObject file : files) {
            if (!file.getName().getBaseName().equals(expectedFile)) continue;
            return true;
        }
        return false;
    }

    @Before
    public void setUp() throws Exception {
        this.manager = new DefaultFileSystemManager();
        this.manager.setFilesCache((FilesCache)new SoftRefFilesCache());
        this.manager.setCacheStrategy(CacheStrategy.ON_RESOLVE);
        this.manager.addProvider("file", (FileProvider)new DefaultLocalFileProvider());
        this.manager.addProvider("tgz", (FileProvider)new TarFileProvider());
        this.manager.addProvider("tar", (FileProvider)new TarFileProvider());
        new File("target/test-classes/test-data/").mkdir();
        this.createLargeFile("target/test-classes/test-data/", largeFileName);
    }

    @Test
    public void testLargeFile() throws Exception {
        File realFile = new File("target/test-classes/test-data/largefile.tar.gz");
        FileObject file = this.manager.resolveFile("tgz:file://" + realFile.getCanonicalPath() + "!/");
        Assert.assertNotNull((Object)file);
        List<FileObject> files = Arrays.asList(file.getChildren());
        Assert.assertNotNull(files);
        Assert.assertEquals((long)1L, (long)files.size());
        FileObject f = files.get(0);
        Assert.assertEquals((String)"Expected file not found: largefile.txt", (Object)f.getName().getBaseName(), (Object)"largefile.txt");
    }
}

