/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.operations;

import java.io.File;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.operations.FileOperation;
import org.apache.commons.vfs2.operations.FileOperationProvider;
import org.apache.commons.vfs2.operations.FileOperations;
import org.apache.commons.vfs2.operations.vcs.VcsLog;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.VfsComponent;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasicOperationsTestCase {
    private DefaultFileSystemManager manager;

    @Before
    public void setUp() throws FileSystemException {
        this.manager = new DefaultFileSystemManager();
        DefaultLocalFileProvider fp = new DefaultLocalFileProvider();
        this.manager.addProvider("file", (FileProvider)fp);
        this.manager.init();
    }

    @After
    public void tearDown() throws FileSystemException {
        if (this.manager != null) {
            this.manager.close();
            this.manager = null;
        }
    }

    @Test
    public void testLifecycleComp() throws FileSystemException {
        MyFileOperationProviderComp myop = new MyFileOperationProviderComp();
        Assert.assertEquals((long)0L, (long)myop.ops);
        this.manager.addOperationProvider("file", (FileOperationProvider)myop);
        Assert.assertEquals((long)7L, (long)myop.ops);
        this.manager.close();
        Assert.assertEquals((String)"close() not called", (long)15L, (long)myop.ops);
    }

    @Test
    public void testLifecycleNoncomp() throws FileSystemException {
        MyFileOperationProviderNoncomp myop = new MyFileOperationProviderNoncomp();
        this.manager.addOperationProvider("file", (FileOperationProvider)myop);
        FileOperationProvider[] ops = this.manager.getOperationProviders("file");
        Assert.assertSame((String)"exactly one provider registered", (Object)1, (Object)ops.length);
        Assert.assertSame((Object)myop, (Object)ops[0]);
        Assert.assertEquals((long)0L, (long)myop.ops);
    }

    @Test
    public void testNotFoundAny() throws FileSystemException {
        MyFileOperationProviderNoncomp myop = new MyFileOperationProviderNoncomp();
        this.manager.addOperationProvider("file", (FileOperationProvider)myop);
        FileObject fo = this.manager.toFileObject(new File("."));
        FileOperations ops = fo.getFileOperations();
        Assert.assertNotNull((Object)ops);
        Class[] oparray = ops.getOperations();
        Assert.assertSame((String)"no ops should be found", (Object)0, (Object)oparray.length);
        Assert.assertSame((Object)16, (Object)myop.ops);
    }

    @Test
    public void testNotFoundOperation() throws FileSystemException {
        MyFileOperationProviderNoncomp myop = new MyFileOperationProviderNoncomp();
        this.manager.addOperationProvider("file", (FileOperationProvider)myop);
        FileObject fo = this.manager.toFileObject(new File("."));
        FileOperations ops = fo.getFileOperations();
        Assert.assertNotNull((Object)ops);
        try {
            FileOperation logop = ops.getOperation(VcsLog.class);
            Assert.fail((String)("Must throw but returned " + logop));
        }
        catch (FileSystemException e) {
            Assert.assertEquals((Object)"vfs.operation/operation-not-supported.error", (Object)e.getCode());
        }
        Assert.assertSame((Object)32, (Object)myop.ops);
    }

    static class MyFileOprationProviderBase
    implements FileOperationProvider {
        int ops;

        MyFileOprationProviderBase() {
        }

        public void collectOperations(Collection<Class<? extends FileOperation>> operationsList, FileObject file) throws FileSystemException {
            Assert.assertNotNull((String)"collect operationsList", operationsList);
            Assert.assertNotNull((String)"collect file", (Object)file);
            this.ops |= 0x10;
        }

        public FileOperation getOperation(FileObject file, Class<? extends FileOperation> operationClass) throws FileSystemException {
            Assert.assertNotNull((String)"file object", (Object)file);
            Assert.assertNotNull((String)"operationclass", operationClass);
            this.ops |= 0x20;
            return null;
        }
    }

    static class MyFileOperationProviderNoncomp
    extends MyFileOprationProviderBase {
        MyFileOperationProviderNoncomp() {
        }
    }

    static class MyFileOperationProviderComp
    extends MyFileOprationProviderBase
    implements VfsComponent {
        MyFileOperationProviderComp() {
        }

        public void close() {
            this.ops |= 8;
        }

        public void init() throws FileSystemException {
            this.ops |= 4;
        }

        public void setContext(VfsComponentContext context) {
            Assert.assertNotNull((String)"setContext", (Object)context);
            this.ops |= 2;
        }

        public void setLogger(Log logger) {
            Assert.assertNotNull((String)"setLogger", (Object)logger);
            this.ops |= 1;
        }
    }
}

