/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileFilterSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.SymbolicLinkFileFilter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class SymbolicLinkFileFilterTest
extends BaseFilterTest {
    private static File testDir;
    private static File targetFile;
    private static FileSelectInfo targetFileInfo;
    private static File linkFile;
    private static FileSelectInfo linkFileInfo;
    private static File notExistingFile;
    private static FileSelectInfo notExistingFileInfo;
    private static File zipFile;
    private static FileObject zipFileObject;

    @AfterClass
    public static void afterClass() throws IOException {
        targetFile = null;
        targetFileInfo = null;
        linkFile = null;
        linkFileInfo = null;
        notExistingFile = null;
        notExistingFileInfo = null;
        if (zipFileObject != null) {
            zipFileObject.close();
        }
        if (zipFile != null) {
            FileUtils.deleteQuietly((File)zipFile);
            zipFile = null;
        }
        if (testDir != null) {
            FileUtils.deleteDirectory((File)testDir);
            testDir = null;
        }
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        Assume.assumeTrue((boolean)Boolean.getBoolean(SymbolicLinkFileFilterTest.class.getSimpleName() + ".Enable"));
        testDir = SymbolicLinkFileFilterTest.getTestDir(SymbolicLinkFileFilterTest.class.getName());
        testDir.mkdir();
        linkFile = new File(testDir, "visible.txt");
        linkFileInfo = SymbolicLinkFileFilterTest.createFileSelectInfo(linkFile);
        targetFile = new File(testDir, "symbolic.txt");
        Files.deleteIfExists(targetFile.toPath());
        FileUtils.touch((File)targetFile);
        Files.createSymbolicLink(linkFile.toPath(), targetFile.toPath(), new FileAttribute[0]);
        targetFileInfo = SymbolicLinkFileFilterTest.createFileSelectInfo(targetFile);
        notExistingFile = new File(testDir, "not-existing-file.txt");
        notExistingFileInfo = SymbolicLinkFileFilterTest.createFileSelectInfo(notExistingFile);
        zipFile = new File(SymbolicLinkFileFilterTest.getTempDir(), SymbolicLinkFileFilterTest.class.getName() + ".zip");
        SymbolicLinkFileFilterTest.zipDir(testDir, "", zipFile);
        zipFileObject = SymbolicLinkFileFilterTest.getZipFileObject(zipFile);
    }

    @Test
    public void testAcceptActual() throws FileSystemException {
        FileFilter testee = SymbolicLinkFileFilter.ACTUAL;
        Assert.assertTrue((boolean)targetFileInfo.getBaseFolder().exists());
        Assert.assertTrue((boolean)targetFileInfo.getFile().exists());
        Assert.assertTrue((String)targetFileInfo.toString(), (boolean)testee.accept(targetFileInfo));
        Assert.assertTrue((String)notExistingFileInfo.toString(), (boolean)testee.accept(notExistingFileInfo));
    }

    @Test
    public void testAcceptSymbolic() throws FileSystemException {
        FileFilter testee = SymbolicLinkFileFilter.SYMBOLIC;
        Assert.assertTrue((String)linkFileInfo.toString(), (boolean)testee.accept(linkFileInfo));
        Assert.assertFalse((String)notExistingFileInfo.toString(), (boolean)testee.accept(notExistingFileInfo));
    }

    @Test
    public void testZipFile() throws FileSystemException {
        FileObject[] files = zipFileObject.findFiles((FileSelector)new FileFilterSelector(SymbolicLinkFileFilter.SYMBOLIC));
        Assert.assertEquals((long)0L, (long)files.length);
    }
}

