/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.IOCase;
import org.apache.commons.vfs2.filter.SuffixFileFilter;
import org.junit.Assert;
import org.junit.Test;

public class SuffixFileFilterTest
extends BaseFilterTest {
    @Test
    public void testAcceptList() throws FileSystemException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(".txt");
        list.add(".bin");
        SuffixFileFilter filter = new SuffixFileFilter(list);
        Assert.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assert.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.bin"))));
        Assert.assertFalse((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.BIN"))));
        Assert.assertFalse((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptListIOCaseInsensitive() throws FileSystemException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(".txt");
        list.add(".bin");
        SuffixFileFilter filter = new SuffixFileFilter(IOCase.INSENSITIVE, list);
        Assert.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("TEST1.txt"))));
        Assert.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.bin"))));
        Assert.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.TXT"))));
        Assert.assertFalse((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptListIOCaseSensitive() throws FileSystemException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(".txt");
        list.add(".bin");
        SuffixFileFilter filter = new SuffixFileFilter(IOCase.SENSITIVE, list);
        Assert.assertFalse((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test1.Txt"))));
        Assert.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.BIN"))));
        Assert.assertFalse((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptString() throws FileSystemException {
        SuffixFileFilter filter = new SuffixFileFilter(new String[]{".txt", ".xxx"});
        Assert.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assert.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.TXT"))));
        Assert.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptStringIOCaseInsensitive() throws FileSystemException {
        SuffixFileFilter filter = new SuffixFileFilter(IOCase.INSENSITIVE, new String[]{".txt", ".xxx"});
        Assert.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assert.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.TXT"))));
        Assert.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptStringIOCaseSensitive() throws FileSystemException {
        SuffixFileFilter filter = new SuffixFileFilter(IOCase.SENSITIVE, new String[]{".txt", ".xxx"});
        Assert.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assert.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.TXT"))));
        Assert.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }
}

