/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.IOCase;
import org.apache.commons.vfs2.filter.NameFileFilter;
import org.junit.Assert;
import org.junit.Test;

public class NameFileFilterTest
extends BaseFilterTest {
    @Test
    public void testAcceptList() throws FileSystemException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("test1.txt");
        list.add("test2.txt");
        NameFileFilter filter = new NameFileFilter(list);
        Assert.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assert.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptListIOCaseInsensitive() throws FileSystemException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("test1.txt");
        list.add("test2.txt");
        NameFileFilter filter = new NameFileFilter(IOCase.INSENSITIVE, list);
        Assert.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("TEST1.txt"))));
        Assert.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptListIOCaseSensitive() throws FileSystemException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("test1.txt");
        list.add("test2.txt");
        NameFileFilter filter = new NameFileFilter(IOCase.SENSITIVE, list);
        Assert.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("TEST1.txt"))));
        Assert.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptString() throws FileSystemException {
        NameFileFilter filter = new NameFileFilter(new String[]{"test1.txt"});
        Assert.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assert.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptStringIOCaseInsensitive() throws FileSystemException {
        NameFileFilter filter = new NameFileFilter(IOCase.INSENSITIVE, new String[]{"test2.txt"});
        Assert.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assert.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptStringIOCaseSensitive() throws FileSystemException {
        NameFileFilter filter = new NameFileFilter(IOCase.SENSITIVE, new String[]{"test2.txt"});
        Assert.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assert.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }
}

