/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.auth;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.junit.Assert;
import org.junit.Test;

public class StaticUserAuthenticatorTestCase {
    @Test
    public void testAuthenticationRequest() {
        StaticUserAuthenticator userAuthenticator = new StaticUserAuthenticator("DOMAIN", "USER", "PWD");
        UserAuthenticationData authenticationData = userAuthenticator.requestAuthentication((UserAuthenticationData.Type[])ArrayUtils.toArray((Object[])new UserAuthenticationData.Type[]{UserAuthenticationData.DOMAIN}));
        Assert.assertArrayEquals((char[])"DOMAIN".toCharArray(), (char[])authenticationData.getData(UserAuthenticationData.DOMAIN));
        Assert.assertNull((Object)authenticationData.getData(UserAuthenticationData.USERNAME));
        Assert.assertNull((Object)authenticationData.getData(UserAuthenticationData.PASSWORD));
        authenticationData = userAuthenticator.requestAuthentication((UserAuthenticationData.Type[])ArrayUtils.toArray((Object[])new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD}));
        Assert.assertNull((Object)authenticationData.getData(UserAuthenticationData.DOMAIN));
        Assert.assertArrayEquals((char[])"USER".toCharArray(), (char[])authenticationData.getData(UserAuthenticationData.USERNAME));
        Assert.assertArrayEquals((char[])"PWD".toCharArray(), (char[])authenticationData.getData(UserAuthenticationData.PASSWORD));
    }

    @Test
    public void testEquality() {
        StaticUserAuthenticator userAuthenticator = new StaticUserAuthenticator("DOMAIN", "USER", "PWD");
        Assert.assertEquals((Object)new StaticUserAuthenticator("DOMAIN", "USER", "PWD"), (Object)userAuthenticator);
        Assert.assertNotEquals((Object)new StaticUserAuthenticator("DOMAIN", "USER", null), (Object)userAuthenticator);
        Assert.assertNotEquals((Object)new StaticUserAuthenticator("DOMAIN", null, "PWD"), (Object)userAuthenticator);
        Assert.assertNotEquals((Object)new StaticUserAuthenticator(null, "USER", "PWD"), (Object)userAuthenticator);
        Assert.assertEquals((long)new StaticUserAuthenticator("DOMAIN", "USER", "PWD").hashCode(), (long)userAuthenticator.hashCode());
    }
}

