/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FileTypeSelector;
import org.apache.commons.vfs2.VFS;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class FileTypeSelectorTest {
    private static FileObject BaseFolder;

    @BeforeClass
    public static void setUpClass() throws Exception {
        BaseFolder = VFS.getManager().resolveFile("ram://" + FileTypeSelectorTest.class.getName());
        BaseFolder.resolveFile("root1.html").createFile();
        BaseFolder.resolveFile("root2.html").createFile();
        BaseFolder.resolveFile("f1/a.html").createFile();
        BaseFolder.resolveFile("f2/b.html").createFile();
        BaseFolder.resolveFile("f3/c.html").createFile();
        BaseFolder.resolveFile("f4/").createFolder();
        BaseFolder.resolveFile("f5/").createFolder();
        BaseFolder.resolveFile("f6/f7").createFolder();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (BaseFolder != null) {
            BaseFolder.deleteAll();
        }
    }

    @Test
    public void testFileOrFolders() throws Exception {
        FileTypeSelector selector = new FileTypeSelector(FileType.FILE_OR_FOLDER);
        FileObject[] foList = BaseFolder.findFiles((FileSelector)selector);
        Assert.assertEquals((long)0L, (long)foList.length);
    }

    @Test
    public void testFiles() throws Exception {
        FileTypeSelector selector = new FileTypeSelector(FileType.FILE);
        FileObject[] foList = BaseFolder.findFiles((FileSelector)selector);
        Assert.assertEquals((long)5L, (long)foList.length);
    }

    @Test
    public void testFolders() throws Exception {
        FileTypeSelector selector = new FileTypeSelector(FileType.FOLDER);
        FileObject[] foList = BaseFolder.findFiles((FileSelector)selector);
        Assert.assertEquals((long)8L, (long)foList.length);
    }
}

