/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.File;
import org.apache.commons.vfs2.AbstractVfsTestCase;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.junit.Test;

public class FileSystemManagerFactoryTestCase
extends AbstractVfsTestCase {
    private void check(FileSystemManager manager, FileObject file) throws FileSystemException {
        FileSystemManagerFactoryTestCase.assertNotNull((Object)file);
        FileSystemManagerFactoryTestCase.assertTrue((boolean)file.exists());
        FileSystemManagerFactoryTestCase.assertSame((Object)FileType.FILE, (Object)file.getType());
        FileSystemManagerFactoryTestCase.assertTrue((boolean)file.isFile());
        file = manager.createFileSystem(file);
        FileSystemManagerFactoryTestCase.assertNotNull((Object)file);
        FileSystemManagerFactoryTestCase.assertTrue((boolean)file.exists());
        FileSystemManagerFactoryTestCase.assertSame((Object)FileType.FOLDER, (Object)file.getType());
        FileSystemManagerFactoryTestCase.assertTrue((boolean)file.isFolder());
    }

    @Test
    public void testDefaultInstance() throws Exception {
        FileSystemManager manager = VFS.getManager();
        File jarFile = FileSystemManagerFactoryTestCase.getTestResource("test.jar");
        FileObject file = manager.toFileObject(jarFile);
        this.check(manager, file);
        FileObject file2 = manager.resolveFile(jarFile.toURI());
        this.check(manager, file2);
        FileObject file3 = manager.resolveFile(jarFile.toURI().toURL());
        this.check(manager, file3);
    }
}

