/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Enumeration;
import junit.extensions.TestSetup;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.AbstractVfsTestCase;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.ProviderTestConfig;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileReplicator;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.PrivilegedFileReplicator;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.TemporaryFileStore;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.junit.Assert;

public abstract class AbstractTestSuite
extends TestSetup {
    private static final Thread[] EMPTY_THREAD_ARRAY = new Thread[0];
    public static final String WRITE_TESTS_FOLDER = "write-tests";
    public static final String READ_TESTS_FOLDER = "read-tests";
    private final ProviderTestConfig providerConfig;
    private final String prefix;
    private TestSuite testSuite;
    private FileObject baseFolder;
    private FileObject readFolder;
    private FileObject writeFolder;
    private DefaultFileSystemManager manager;
    private File tempDir;
    private Thread[] startThreadSnapshot;
    private Thread[] endThreadSnapshot;
    private final boolean addEmptyDir;

    protected AbstractTestSuite(ProviderTestConfig providerConfig, String prefix, boolean nested) throws Exception {
        this(providerConfig, prefix, nested, false);
    }

    protected AbstractTestSuite(ProviderTestConfig providerConfig, String prefix, boolean nested, boolean addEmptyDir) throws Exception {
        super((Test)new TestSuite());
        this.testSuite = (TestSuite)this.fTest;
        this.providerConfig = providerConfig;
        this.prefix = prefix;
        this.addEmptyDir = addEmptyDir;
        this.addBaseTests();
        if (!nested) {
            // empty if block
        }
    }

    protected void addBaseTests() throws Exception {
    }

    public void addTests(Class<?> testClass) throws Exception {
        Method[] methods;
        if (!AbstractProviderTestCase.class.isAssignableFrom(testClass)) {
            throw new Exception("Test class " + testClass.getName() + " is not assignable to " + AbstractProviderTestCase.class.getName());
        }
        for (Method method2 : methods = testClass.getMethods()) {
            Method method = method2;
            if (!method.getName().startsWith("test") || Modifier.isStatic(method.getModifiers()) || method.getReturnType() != Void.TYPE || method.getParameterTypes().length != 0) continue;
            AbstractProviderTestCase testCase = (AbstractProviderTestCase)((Object)testClass.newInstance());
            testCase.setMethod(method);
            testCase.setName(this.prefix + method.getName());
            testCase.addEmptyDir(this.addEmptyDir);
            this.testSuite.addTest((Test)testCase);
        }
    }

    private void checkTempDir(String assertMsg) {
        if (this.tempDir.exists()) {
            Assert.assertTrue((String)(assertMsg + " (" + this.tempDir.getAbsolutePath() + ")"), (this.tempDir.isDirectory() && ArrayUtils.isEmpty((Object[])this.tempDir.list()) ? 1 : 0) != 0);
        }
    }

    private Thread[] createThreadSnapshot() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        Thread[] snapshot = new Thread[200];
        tg.enumerate(snapshot, true);
        return snapshot;
    }

    private Thread[] diffThreadSnapshot(Thread[] startThreadSnapshot, Thread[] endThreadSnapshot) {
        ArrayList<Thread> diff = new ArrayList<Thread>(10);
        block0: for (Thread element : endThreadSnapshot) {
            for (Thread element2 : startThreadSnapshot) {
                if (element2 == element) continue block0;
            }
            diff.add(element);
        }
        return diff.toArray(EMPTY_THREAD_ARRAY);
    }

    private String dumpThreadSnapshot(Thread[] threadSnapshot) {
        if (ArrayUtils.isEmpty((Object[])threadSnapshot)) {
            return "";
        }
        StringBuffer sb = new StringBuffer(256);
        sb.append("Threads still running (" + threadSnapshot.length + ") at " + Instant.now() + ", live threads:");
        sb.append(System.lineSeparator());
        Field threadTargetField = null;
        try {
            threadTargetField = Thread.class.getDeclaredField("target");
            threadTargetField.setAccessible(true);
        }
        catch (Exception e) {
            System.err.println("Test suite cannot show you a thread snapshot: " + e);
        }
        int liveCount = 0;
        for (int index = 0; index < threadSnapshot.length; ++index) {
            Thread thread = threadSnapshot[index];
            if (thread == null || !thread.isAlive()) continue;
            ++liveCount;
            sb.append("\tThread[");
            sb.append(index);
            sb.append("] ");
            sb.append(" ID ");
            sb.append(thread.getId());
            sb.append(", ");
            sb.append(thread);
            sb.append(",\t");
            sb.append((Object)thread.getState());
            sb.append(",\t");
            if (!thread.isDaemon()) {
                sb.append("non_");
            }
            sb.append("daemon");
            if (threadTargetField != null) {
                sb.append(",\t");
                try {
                    Object threadTarget = threadTargetField.get(thread);
                    if (threadTarget != null) {
                        sb.append(threadTarget.getClass().getCanonicalName());
                    } else {
                        sb.append("null");
                    }
                }
                catch (IllegalAccessException e) {
                    sb.append("unknown (");
                    sb.append(e);
                    sb.append(")");
                }
            }
            sb.append(System.lineSeparator());
        }
        return liveCount == 0 ? "" : sb.toString();
    }

    public void run(TestResult result) {
        Protectable p = () -> {
            this.setUp();
            this.basicRun(result);
            this.tearDown();
            this.validateThreadSnapshot();
        };
        result.runProtected((Test)this, p);
    }

    protected void setUp() throws Exception {
        this.startThreadSnapshot = this.createThreadSnapshot();
        this.tempDir = AbstractVfsTestCase.getTestDirectory("temp");
        FileUtils.cleanDirectory((File)this.tempDir);
        this.checkTempDir("Temp dir not empty before test");
        this.manager = this.providerConfig.getDefaultFileSystemManager();
        this.manager.setFilesCache(this.providerConfig.getFilesCache());
        DefaultFileReplicator replicator = new DefaultFileReplicator(this.tempDir);
        this.manager.setReplicator((FileReplicator)new PrivilegedFileReplicator((FileReplicator)replicator));
        this.manager.setTemporaryFileStore((TemporaryFileStore)replicator);
        this.providerConfig.prepare(this.manager);
        if (!this.manager.hasProvider("file")) {
            this.manager.addProvider("file", (FileProvider)new DefaultLocalFileProvider());
        }
        this.manager.init();
        this.baseFolder = this.providerConfig.getBaseTestFolder((FileSystemManager)this.manager);
        this.readFolder = this.baseFolder.resolveFile(READ_TESTS_FOLDER);
        this.writeFolder = this.baseFolder.resolveFile(WRITE_TESTS_FOLDER);
        Assert.assertTrue((String)("Folder does not exist: " + this.readFolder), (boolean)this.readFolder.exists());
        Assert.assertNotEquals((Object)this.readFolder.getName().getPath(), (Object)"/");
        Enumeration tests = this.testSuite.tests();
        if (!tests.hasMoreElements()) {
            Assert.fail((String)"No tests.");
        }
        while (tests.hasMoreElements()) {
            Test test = (Test)tests.nextElement();
            if (!(test instanceof AbstractProviderTestCase)) continue;
            AbstractProviderTestCase providerTestCase = (AbstractProviderTestCase)test;
            providerTestCase.setConfig(this.manager, this.providerConfig, this.baseFolder, this.readFolder, this.writeFolder);
        }
    }

    protected void tearDown() throws Exception {
        this.readFolder.close();
        this.writeFolder.close();
        this.baseFolder.close();
        this.readFolder = null;
        this.writeFolder = null;
        this.baseFolder = null;
        this.testSuite = null;
        System.gc();
        Thread.sleep(1000L);
        System.gc();
        Thread.sleep(1000L);
        System.gc();
        Thread.sleep(1000L);
        System.gc();
        Thread.sleep(1000L);
        this.manager.freeUnusedResources();
        this.manager.close();
        Thread.sleep(20L);
        this.checkTempDir("Temp dir not empty after test");
        VFS.close();
    }

    private void validateThreadSnapshot() {
        this.endThreadSnapshot = this.createThreadSnapshot();
        Thread[] diffThreadSnapshot = this.diffThreadSnapshot(this.startThreadSnapshot, this.endThreadSnapshot);
        if (diffThreadSnapshot.length > 0) {
            String message = this.dumpThreadSnapshot(diffThreadSnapshot);
            System.out.print(message);
        }
    }
}

