/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.TreeProcessor;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.util.location.Location;
import org.apache.commons.lang.BooleanUtils;

public class MountNode
extends AbstractProcessingNode
implements Disposable {
    public static final String COCOON_PASS_THROUGH = "COCOON_PASS_THROUGH";
    private final VariableResolver prefix;
    private final VariableResolver source;
    private Map processors = new HashMap();
    private final TreeProcessor parentProcessor;
    private final boolean checkReload;
    private final Boolean passThrough;

    public MountNode(VariableResolver prefix, VariableResolver source, TreeProcessor parentProcessor, boolean checkReload, boolean passThrough) {
        this.prefix = prefix;
        this.source = source;
        this.parentProcessor = parentProcessor;
        this.checkReload = checkReload;
        this.passThrough = BooleanUtils.toBooleanObject((boolean)passThrough);
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        boolean pp2;
        Object oldPassThrough;
        String oldURI;
        String oldPrefix;
        TreeProcessor processor;
        block16: {
            block17: {
                Map objectModel = env.getObjectModel();
                String resolvedSource = this.source.resolve(context, objectModel);
                String resolvedPrefix = this.prefix.resolve(context, objectModel);
                if (resolvedSource.length() == 0) {
                    throw new ProcessingException("Source of mount statement is empty");
                }
                if (resolvedSource.charAt(resolvedSource.length() - 1) == '/') {
                    resolvedSource = resolvedSource + "sitemap.xmap";
                }
                processor = this.getProcessor(resolvedSource, resolvedPrefix);
                oldPrefix = env.getURIPrefix();
                oldURI = env.getURI();
                oldPassThrough = env.getAttribute(COCOON_PASS_THROUGH);
                env.setAttribute(COCOON_PASS_THROUGH, (Object)this.passThrough);
                processor.getEnvironmentHelper().changeContext(env);
                if (!context.isBuildingPipelineOnly()) break block16;
                Processor.InternalPipelineDescription pp2 = processor.buildPipeline(env);
                if (pp2 == null) break block17;
                context.setInternalPipelineDescription(pp2);
                boolean bl = true;
                Object var13_15 = null;
                env.setURI(oldPrefix, oldURI);
                if (oldPassThrough != null) {
                    env.setAttribute(COCOON_PASS_THROUGH, oldPassThrough);
                } else {
                    env.removeAttribute(COCOON_PASS_THROUGH);
                }
                return bl;
            }
            boolean bl = false;
            Object var13_16 = null;
            env.setURI(oldPrefix, oldURI);
            if (oldPassThrough != null) {
                env.setAttribute(COCOON_PASS_THROUGH, oldPassThrough);
            } else {
                env.removeAttribute(COCOON_PASS_THROUGH);
            }
            return bl;
        }
        try {
            pp2 = processor.process(env);
            Object var13_17 = null;
        }
        catch (Exception e) {
            try {
                throw ProcessingException.throwLocated((String)"Sitemap: error when calling sub-sitemap", (Throwable)e, (Location)this.getLocation());
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                env.setURI(oldPrefix, oldURI);
                if (oldPassThrough != null) {
                    env.setAttribute(COCOON_PASS_THROUGH, oldPassThrough);
                } else {
                    env.removeAttribute(COCOON_PASS_THROUGH);
                }
                throw throwable;
            }
        }
        env.setURI(oldPrefix, oldURI);
        if (oldPassThrough != null) {
            env.setAttribute(COCOON_PASS_THROUGH, oldPassThrough);
        } else {
            env.removeAttribute(COCOON_PASS_THROUGH);
        }
        return pp2;
    }

    private synchronized TreeProcessor getProcessor(String source, String prefix) throws Exception {
        TreeProcessor processor = (TreeProcessor)((Object)this.processors.get(source));
        if (processor == null) {
            processor = this.parentProcessor.createChildProcessor(source, this.checkReload, prefix);
            this.processors.put(source, processor);
        }
        return processor;
    }

    public void dispose() {
        Iterator i = this.processors.values().iterator();
        while (i.hasNext()) {
            ContainerUtil.dispose(i.next());
        }
        this.processors.clear();
    }
}

