/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.classloader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.List;
import org.apache.cocoon.util.WildcardMatcherHelper;

public class DefaultClassLoader
extends URLClassLoader {
    protected final List includes;
    protected final List excludes;

    public DefaultClassLoader(URL[] urls, List includePatterns, List excludePatterns, ClassLoader parent) {
        this(urls, includePatterns, excludePatterns, parent, null);
    }

    public DefaultClassLoader(URL[] urls, List includePatterns, List excludePatterns, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
        this.includes = includePatterns;
        this.excludes = excludePatterns;
    }

    protected boolean tryClassHere(String name) {
        int i;
        boolean tryHere;
        if (name != null && (name.startsWith("java.") || name.startsWith("javax.servlet"))) {
            return false;
        }
        if (this.includes == null || this.includes.size() == 0) {
            tryHere = true;
        } else {
            tryHere = false;
            for (i = 0; i < this.includes.size(); ++i) {
                if (WildcardMatcherHelper.match((String)((String)this.includes.get(i)), (String)name) == null) continue;
                tryHere = true;
                break;
            }
        }
        if (tryHere && this.excludes != null && this.excludes.size() > 0) {
            for (i = 0; i < this.excludes.size(); ++i) {
                if (WildcardMatcherHelper.match((String)((String)this.excludes.get(i)), (String)name) == null) continue;
                tryHere = false;
                break;
            }
        }
        return tryHere;
    }

    protected Class getClass(String name) throws ClassNotFoundException {
        return this.findClass(name);
    }

    public final Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            ClassLoader parent;
            block7: {
                parent = this.getParent();
                if (this.tryClassHere(name)) {
                    try {
                        clazz = this.getClass(name);
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (parent != null) break block7;
                        throw cnfe;
                    }
                }
            }
            if (clazz == null) {
                if (parent == null) {
                    throw new ClassNotFoundException(name);
                }
                clazz = parent.loadClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public final URL getResource(String name) {
        URL resource = this.findResource(name);
        ClassLoader parent = this.getParent();
        if (resource == null && parent != null) {
            resource = parent.getResource(name);
        }
        return resource;
    }

    public final void addDirectory(File file) throws IOException {
        this.addURL(file.getCanonicalFile().toURL());
    }

    public void addURL(URL url) {
        super.addURL(url);
    }
}

