/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.util.SourceUtil;
import org.apache.cocoon.core.xml.SAXParser;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FileGenerator
extends ServiceableGenerator
implements CacheableProcessingComponent {
    protected Source inputSource;
    protected SAXParser parser;

    public void setParser(SAXParser parser) {
        this.parser = parser;
    }

    public void recycle() {
        if (this.inputSource != null) {
            this.resolver.release(this.inputSource);
            this.inputSource = null;
        }
        if (this.parser != null) {
            this.manager.release((Object)this.parser);
            this.parser = null;
        }
        super.recycle();
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        try {
            if (this.parser == null) {
                this.parser = (SAXParser)this.manager.lookup(SAXParser.class.getName());
            }
        }
        catch (ServiceException e) {
            throw new ProcessingException("Exception when getting parser.", (Throwable)e);
        }
        try {
            this.inputSource = this.resolver.resolveURI(src);
        }
        catch (SourceException se) {
            throw SourceUtil.handle((String)("Error during resolving of '" + src + "'."), (SourceException)se);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Source " + this.source + " resolved to " + this.inputSource.getURI()));
        }
    }

    public Serializable getKey() {
        return this.inputSource.getURI();
    }

    public SourceValidity getValidity() {
        return this.inputSource.getValidity();
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            SourceUtil.parse((SAXParser)this.parser, (Source)this.inputSource, (ContentHandler)this.xmlConsumer);
        }
        catch (SAXException e) {
            SourceUtil.handleSAXException((String)this.inputSource.getURI(), (SAXException)e);
        }
    }
}

