/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.xslt;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.util.SourceUtil;
import org.apache.cocoon.components.xslt.XSLTProcessor;
import org.apache.cocoon.components.xslt.XSLTProcessorErrorListener;
import org.apache.cocoon.components.xslt.XSLTProcessorException;
import org.apache.cocoon.core.xml.SAXParser;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.AggregatedValidity;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public class XSLTProcessorImpl
extends AbstractLogEnabled
implements XSLTProcessor,
URIResolver {
    protected Store store;
    protected String transformerFactory;
    protected SAXTransformerFactory factory;
    protected boolean incrementalProcessing;
    protected SourceResolver resolver;
    protected boolean checkIncludes;
    protected Map includesMap = new HashMap();
    protected SAXParser saxParser;

    public void init() throws Exception {
        this.factory = this.getTransformerFactory(this.transformerFactory);
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public void setIncrementalProcessing(boolean incrementalProcessing) {
        this.incrementalProcessing = incrementalProcessing;
    }

    public void setResolver(SourceResolver resolver) {
        this.resolver = resolver;
    }

    public void setCheckIncludes(boolean checkIncludes) {
        this.checkIncludes = checkIncludes;
    }

    public void setSaxParser(SAXParser saxParser) {
        this.saxParser = saxParser;
    }

    public void setTransformerFactory(String classname) {
        this.transformerFactory = classname;
    }

    public TransformerHandler getTransformerHandler(Source stylesheet) throws XSLTProcessorException {
        return this.getTransformerHandler(stylesheet, null);
    }

    public TransformerHandler getTransformerHandler(Source stylesheet, XMLFilter filter) throws XSLTProcessorException {
        XSLTProcessor.TransformerHandlerAndValidity validity = this.getTransformerHandlerAndValidity(stylesheet, filter);
        return validity.getTransfomerHandler();
    }

    public XSLTProcessor.TransformerHandlerAndValidity getTransformerHandlerAndValidity(Source stylesheet) throws XSLTProcessorException {
        return this.getTransformerHandlerAndValidity(stylesheet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSLTProcessor.TransformerHandlerAndValidity getTransformerHandlerAndValidity(Source stylesheet, XMLFilter filter) throws XSLTProcessorException {
        XSLTProcessor.TransformerHandlerAndValidity handlerAndValidity;
        String id = stylesheet.getURI();
        try {
            handlerAndValidity = this.getTemplates(stylesheet, id);
            if (handlerAndValidity != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Reusing Templates for " + id));
                }
                return handlerAndValidity;
            }
        }
        catch (Exception e) {
            throw new XSLTProcessorException("Error retrieving template", e);
        }
        XSLTProcessorErrorListener errorListener = new XSLTProcessorErrorListener(this.getLogger(), stylesheet.getURI());
        try {
            SourceValidity validity;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Creating new Templates for " + id));
            }
            this.factory.setErrorListener(errorListener);
            TemplatesHandler templatesHandler = this.factory.newTemplatesHandler();
            templatesHandler.setSystemId(id);
            if (filter != null) {
                filter.setContentHandler(templatesHandler);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Source = " + stylesheet + ", templatesHandler = " + templatesHandler));
            }
            if ((validity = stylesheet.getValidity()) != null && this.checkIncludes) {
                this.includesMap.put(id, new ArrayList());
            }
            try {
                List includes;
                this.sourceToSAX(stylesheet, filter != null ? (ContentHandler)((Object)filter) : templatesHandler);
                Templates template = templatesHandler.getTemplates();
                if (null == template) {
                    throw new XSLTProcessorException("Unable to create templates for stylesheet: " + stylesheet.getURI());
                }
                Class<?> clazz = template.getClass();
                if (clazz.getName().equals("org.apache.xalan.templates.StylesheetRoot")) {
                    Method method = clazz.getMethod("setHref", String.class);
                    method.invoke((Object)template, id);
                }
                this.putTemplates(template, stylesheet, id);
                TransformerHandler handler = this.factory.newTransformerHandler(template);
                handler.getTransformer().setErrorListener(new XSLTProcessorErrorListener(this.getLogger(), stylesheet.getURI()));
                handler.getTransformer().setURIResolver(this);
                AggregatedValidity aggregated = null;
                if (validity != null && this.checkIncludes && (includes = (List)this.includesMap.get(id)) != null) {
                    aggregated = new AggregatedValidity();
                    aggregated.add(validity);
                    for (int i = includes.size() - 1; i >= 0; --i) {
                        aggregated.add((SourceValidity)((Object[])includes.get(i))[1]);
                    }
                    validity = aggregated;
                }
                handlerAndValidity = new MyTransformerHandlerAndValidity(handler, validity);
            }
            finally {
                if (this.checkIncludes) {
                    this.includesMap.remove(id);
                }
            }
            return handlerAndValidity;
        }
        catch (Exception e) {
            Throwable realEx = errorListener.getThrowable();
            if (realEx == null) {
                realEx = e;
            }
            if (realEx instanceof RuntimeException) {
                throw (RuntimeException)realEx;
            }
            if (realEx instanceof XSLTProcessorException) {
                throw (XSLTProcessorException)realEx;
            }
            throw new XSLTProcessorException("Exception when creating Transformer from " + stylesheet.getURI(), realEx);
        }
    }

    private void sourceToSAX(Source source, ContentHandler handler) throws SAXException, IOException, SourceException, ProcessingException {
        if (source instanceof XMLizable) {
            ((XMLizable)source).toSAX(handler);
        } else {
            this.saxParser.parse(SourceUtil.getInputSource((Source)source), handler);
        }
    }

    public void transform(Source source, Source stylesheet, Map params, Result result) throws XSLTProcessorException {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Transform source = " + source + ", stylesheet = " + stylesheet + ", parameters = " + params + ", result = " + result));
            }
            TransformerHandler handler = this.getTransformerHandler(stylesheet);
            if (params != null) {
                Transformer transformer = handler.getTransformer();
                transformer.clearParameters();
                Iterator i = params.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry current = i.next();
                    transformer.setParameter(current.getKey().toString(), current.getValue());
                }
            }
            handler.setResult(result);
            this.sourceToSAX(source, handler);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Transform done");
            }
        }
        catch (SAXException e) {
            String message = "Error in running Transformation";
            throw new XSLTProcessorException("Error in running Transformation", e);
        }
        catch (Exception e) {
            String message = "Error in running Transformation";
            throw new XSLTProcessorException("Error in running Transformation", e);
        }
    }

    private SAXTransformerFactory getTransformerFactory(String factoryName) {
        SAXTransformerFactory _factory;
        if (null == factoryName) {
            _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
        } else {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = this.getClass().getClassLoader();
                }
                _factory = (SAXTransformerFactory)loader.loadClass(factoryName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                this.getLogger().error((Object)("Cannot find the requested TrAX factory '" + factoryName + "'. Using default TrAX Transformer Factory instead."));
                if (this.factory != null) {
                    return this.factory;
                }
                _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
            catch (ClassCastException cce) {
                this.getLogger().error((Object)("The indicated class '" + factoryName + "' is not a TrAX Transformer Factory. Using default TrAX Transformer Factory instead."));
                if (this.factory != null) {
                    return this.factory;
                }
                _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
            catch (Exception e) {
                this.getLogger().error((Object)("Error found loading the requested TrAX Transformer Factory '" + factoryName + "'. Using default TrAX Transformer Factory instead."));
                if (this.factory != null) {
                    return this.factory;
                }
                _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
        }
        _factory.setErrorListener(new XSLTProcessorErrorListener(this.getLogger(), null));
        _factory.setURIResolver(this);
        if (_factory.getClass().getName().equals("org.apache.xalan.processor.TransformerFactoryImpl")) {
            _factory.setAttribute("http://xml.apache.org/xalan/features/incremental", this.incrementalProcessing);
        }
        if (_factory.getClass().getName().equals("net.sf.saxon.TransformerFactoryImpl")) {
            _factory.setAttribute("http://saxon.sf.net/feature/version-warning", Boolean.FALSE);
        }
        return _factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XSLTProcessor.TransformerHandlerAndValidity getTemplates(Source stylesheet, String id) throws IOException, TransformerException {
        SourceValidity storedValidity;
        Object[] templateAndValidityAndIncludes;
        block11: {
            boolean isValid;
            SourceValidity newValidity;
            if (this.store == null) {
                return null;
            }
            String key = "XSLTTemplate: " + id + '(' + this.factory.getClass().getName() + ')';
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("getTemplates: stylesheet " + id));
            }
            if ((newValidity = stylesheet.getValidity()) == null) {
                this.store.remove((Object)key);
                return null;
            }
            templateAndValidityAndIncludes = (Object[])this.store.get((Object)key);
            if (templateAndValidityAndIncludes == null) {
                return null;
            }
            storedValidity = (SourceValidity)templateAndValidityAndIncludes[1];
            int valid = storedValidity.isValid();
            if (valid == 0) {
                valid = storedValidity.isValid(newValidity);
                isValid = valid == 1;
            } else {
                boolean bl = isValid = valid == 1;
            }
            if (!isValid) {
                this.store.remove((Object)key);
                return null;
            }
            if (!this.checkIncludes) break block11;
            AggregatedValidity aggregated = null;
            List includes = (List)templateAndValidityAndIncludes[2];
            if (includes == null) break block11;
            aggregated = new AggregatedValidity();
            aggregated.add(storedValidity);
            for (int i = includes.size() - 1; i >= 0; --i) {
                block13: {
                    block12: {
                        Source includedSource;
                        block10: {
                            Object[] pair = (Object[])includes.get(i);
                            storedValidity = (SourceValidity)pair[1];
                            aggregated.add(storedValidity);
                            valid = storedValidity.isValid();
                            isValid = false;
                            if (valid != 0) break block12;
                            includedSource = null;
                            try {
                                includedSource = this.resolver.resolveURI((String)pair[0]);
                                SourceValidity included = includedSource.getValidity();
                                if (included == null) break block10;
                                valid = storedValidity.isValid(included);
                                isValid = valid == 1;
                            }
                            catch (Throwable throwable) {
                                this.resolver.release(includedSource);
                                throw throwable;
                            }
                        }
                        this.resolver.release(includedSource);
                        break block13;
                    }
                    boolean bl = isValid = valid == 1;
                }
                if (isValid) continue;
                this.store.remove((Object)key);
                return null;
            }
            storedValidity = aggregated;
        }
        TransformerHandler handler = this.factory.newTransformerHandler((Templates)templateAndValidityAndIncludes[0]);
        handler.getTransformer().setErrorListener(new XSLTProcessorErrorListener(this.getLogger(), stylesheet.getURI()));
        handler.getTransformer().setURIResolver(this);
        return new MyTransformerHandlerAndValidity(handler, storedValidity);
    }

    private void putTemplates(Templates templates, Source stylesheet, String id) throws IOException {
        if (this.store == null) {
            return;
        }
        String key = "XSLTTemplate: " + id + '(' + this.factory.getClass().getName() + ')';
        SourceValidity validity = stylesheet.getValidity();
        if (null != validity) {
            Object[] templateAndValidityAndIncludes = new Object[3];
            templateAndValidityAndIncludes[0] = templates;
            templateAndValidityAndIncludes[1] = validity;
            if (this.checkIncludes) {
                templateAndValidityAndIncludes[2] = this.includesMap.get(id);
            }
            this.store.store((Object)key, (Object)templateAndValidityAndIncludes);
        }
    }

    /*
     * Exception decompiling
     */
    public javax.xml.transform.Source resolve(String href, String base) throws TransformerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static InputSource getInputSource(Source source) throws IOException, SourceException {
        InputSource newObject = new InputSource(source.getInputStream());
        newObject.setSystemId(source.getURI());
        return newObject;
    }

    public static class MyTransformerHandlerAndValidity
    extends XSLTProcessor.TransformerHandlerAndValidity {
        protected MyTransformerHandlerAndValidity(TransformerHandler handler, SourceValidity validity) {
            super(handler, validity);
        }
    }
}

