/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.cocoon.util.MIMEUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;

public class ZipSource
extends AbstractLogEnabled
implements Source {
    private String protocol;
    private Source archive;
    private String filePath;

    public ZipSource(String protocol, Source archive, String filePath) {
        this.protocol = protocol;
        this.archive = archive;
        this.filePath = filePath;
    }

    private ZipEntry findEntry(ZipInputStream zipStream) throws IOException {
        ZipEntry entry;
        while ((entry = zipStream.getNextEntry()) != null) {
            if (entry.getName().equals(this.filePath)) {
                return entry;
            }
            zipStream.closeEntry();
        }
        return null;
    }

    void dispose(SourceResolver resolver) {
        resolver.release(this.archive);
        this.archive = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exists() {
        boolean bl;
        if (!this.archive.exists()) {
            return false;
        }
        ZipInputStream zipStream = null;
        try {
            try {
                zipStream = new ZipInputStream(this.archive.getInputStream());
                bl = this.findEntry(zipStream) != null;
                Object var5_4 = null;
            }
            catch (IOException e) {
                boolean bl2 = false;
                Object var5_5 = null;
                try {
                    if (zipStream == null) return bl2;
                    zipStream.close();
                    return bl2;
                }
                catch (IOException e2) {
                    this.getLogger().error((Object)("IOException while closing ZipInputStream: " + this.filePath));
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {}
            catch (IOException e2) {
                this.getLogger().error((Object)("IOException while closing ZipInputStream: " + this.filePath));
                throw throwable;
            }
            if (zipStream == null) throw throwable;
            zipStream.close();
            throw throwable;
        }
        try {}
        catch (IOException e2) {
            this.getLogger().error((Object)("IOException while closing ZipInputStream: " + this.filePath));
            return bl;
        }
        if (zipStream == null) return bl;
        zipStream.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        ZipInputStream zipStream = new ZipInputStream(this.archive.getInputStream());
        try {
            ZipEntry entry = this.findEntry(zipStream);
            if (entry == null) {
                throw new SourceNotFoundException("File " + this.filePath + " is not found in the archive " + this.archive.getURI());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while (zipStream.available() > 0) {
                int length = zipStream.read(buffer, 0, 8192);
                if (length <= 0) continue;
                baos.write(buffer, 0, length);
            }
            byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                zipStream.close();
            }
            catch (IOException e) {
                this.getLogger().error((Object)("IOException while closing ZipInputStream: " + this.filePath));
            }
            throw throwable;
        }
        try {
            zipStream.close();
        }
        catch (IOException e) {
            this.getLogger().error((Object)("IOException while closing ZipInputStream: " + this.filePath));
        }
        return byteArrayInputStream;
    }

    public String getURI() {
        return this.protocol + ":" + this.archive.getURI() + "!/" + this.filePath;
    }

    public String getScheme() {
        return this.protocol;
    }

    public SourceValidity getValidity() {
        return this.archive.getValidity();
    }

    public void refresh() {
    }

    public String getMimeType() {
        String ext = this.filePath.substring(this.filePath.lastIndexOf("."));
        return MIMEUtils.getMIMEType((String)ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public long getContentLength() {
        block14: {
            ZipInputStream zipStream;
            block13: {
                zipStream = null;
                zipStream = new ZipInputStream(this.archive.getInputStream());
                ZipEntry entry = this.findEntry(zipStream);
                if (entry == null) break block13;
                long l = entry.getSize();
                Object var6_5 = null;
                try {
                    if (zipStream != null) {
                        zipStream.close();
                    }
                }
                catch (IOException e) {
                    this.getLogger().error((Object)("IOException while closing ZipInputStream: " + this.filePath));
                }
                return l;
            }
            Object var6_6 = null;
            try {
                if (zipStream != null) {
                    zipStream.close();
                }
                break block14;
            }
            catch (IOException e) {
                this.getLogger().error((Object)("IOException while closing ZipInputStream: " + this.filePath));
            }
            break block14;
            {
                catch (IOException iOException) {
                    Object var6_7 = null;
                    try {
                        if (zipStream != null) {
                            zipStream.close();
                        }
                        break block14;
                    }
                    catch (IOException e) {
                        this.getLogger().error((Object)("IOException while closing ZipInputStream: " + this.filePath));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (zipStream != null) {
                        zipStream.close();
                    }
                }
                catch (IOException e) {
                    this.getLogger().error((Object)("IOException while closing ZipInputStream: " + this.filePath));
                }
                throw throwable;
            }
        }
        return -1L;
    }

    public long getLastModified() {
        return this.archive.getLastModified();
    }
}

