/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.cocoon.xml.XMLConsumer;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class IncludeXMLConsumer
implements XMLConsumer {
    private static final TransformerFactory FACTORY = TransformerFactory.newInstance();
    private final ContentHandler contentHandler;
    private final LexicalHandler lexicalHandler;
    private boolean ignoreEmptyCharacters;
    private boolean ignoreRootElement;
    private int ignoreRootElementCount;
    private boolean inDTD;

    public IncludeXMLConsumer(XMLConsumer consumer) {
        this((ContentHandler)consumer, (LexicalHandler)consumer);
    }

    public IncludeXMLConsumer(ContentHandler contentHandler) {
        this(contentHandler, contentHandler instanceof LexicalHandler ? (LexicalHandler)((Object)contentHandler) : null);
    }

    public IncludeXMLConsumer(ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        this.contentHandler = contentHandler;
        this.lexicalHandler = lexicalHandler;
    }

    public static void includeNode(Node node, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws SAXException {
        if (node != null) {
            if (node.getNodeType() == 3) {
                String value = node.getNodeValue();
                contentHandler.characters(value.toCharArray(), 0, value.length());
            } else {
                try {
                    IncludeXMLConsumer filter = new IncludeXMLConsumer(contentHandler, lexicalHandler);
                    Transformer transformer = FACTORY.newTransformer();
                    DOMSource source = new DOMSource(node);
                    SAXResult result = new SAXResult((ContentHandler)((Object)filter));
                    result.setLexicalHandler((LexicalHandler)((Object)filter));
                    transformer.transform(source, result);
                }
                catch (TransformerConfigurationException e) {
                    throw new SAXException("TransformerConfigurationException", e);
                }
                catch (TransformerException e) {
                    throw new SAXException("TransformerException", e);
                }
            }
        }
    }

    public void setIgnoreEmptyCharacters(boolean value) {
        this.ignoreEmptyCharacters = value;
    }

    public void setIgnoreRootElement(boolean value) {
        this.ignoreRootElement = value;
        this.ignoreRootElementCount = 0;
    }

    public void setDocumentLocator(Locator loc) {
        this.contentHandler.setDocumentLocator(loc);
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.contentHandler.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String local, String qName, Attributes attr) throws SAXException {
        if (!this.ignoreRootElement || this.ignoreRootElementCount > 0) {
            this.contentHandler.startElement(uri, local, qName, attr);
        }
        ++this.ignoreRootElementCount;
    }

    public void endElement(String uri, String local, String qName) throws SAXException {
        --this.ignoreRootElementCount;
        if (!this.ignoreRootElement || this.ignoreRootElementCount > 0) {
            this.contentHandler.endElement(uri, local, qName);
        }
    }

    public void characters(char[] ch, int start, int end) throws SAXException {
        if (this.ignoreEmptyCharacters) {
            String text = new String(ch, start, end).trim();
            if (text.length() > 0) {
                this.contentHandler.characters(text.toCharArray(), 0, text.length());
            }
        } else {
            this.contentHandler.characters(ch, start, end);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int end) throws SAXException {
        if (!this.ignoreEmptyCharacters) {
            this.contentHandler.ignorableWhitespace(ch, start, end);
        }
    }

    public void processingInstruction(String name, String value) throws SAXException {
        this.contentHandler.processingInstruction(name, value);
    }

    public void skippedEntity(String ent) throws SAXException {
        this.contentHandler.skippedEntity(ent);
    }

    public void startDTD(String name, String public_id, String system_id) throws SAXException {
        this.inDTD = true;
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    public void startEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    public void comment(char[] ary, int start, int length) throws SAXException {
        if (!this.inDTD && this.lexicalHandler != null) {
            this.lexicalHandler.comment(ary, start, length);
        }
    }
}

