/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet.multipart;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.cocoon.environment.ValueHolder;
import org.apache.cocoon.servlet.multipart.Part;

public class MultipartHttpServletRequest
extends HttpServletRequestWrapper
implements ValueHolder {
    private Hashtable values;

    public MultipartHttpServletRequest(HttpServletRequest request, Hashtable values) {
        super(request);
        this.values = values;
    }

    public void cleanup() throws IOException {
        Enumeration e = this.getParameterNames();
        while (e.hasMoreElements()) {
            Part part;
            Object o = this.get((String)e.nextElement());
            if (!(o instanceof Part) || !(part = (Part)o).disposeWithRequest()) continue;
            part.dispose();
        }
    }

    public Object get(String name) {
        Vector<String> result = null;
        if (this.values != null) {
            result = (Vector<String>)this.values.get(name);
            if (result instanceof Vector) {
                if (((Vector)result).size() == 1) {
                    return ((Vector)result).elementAt(0);
                }
                return result;
            }
        } else {
            String[] array = this.getRequest().getParameterValues(name);
            Vector<String> vec = new Vector<String>();
            if (array != null) {
                for (int i = 0; i < array.length; ++i) {
                    vec.addElement(array[i]);
                }
                result = vec.size() == 1 ? vec.elementAt(0) : vec;
            }
        }
        return result;
    }

    public Enumeration getParameterNames() {
        if (this.values != null) {
            return this.values.keys();
        }
        return this.getRequest().getParameterNames();
    }

    public String getParameter(String name) {
        if (this.values != null) {
            Object value = this.get(name);
            String result = null;
            if (value != null) {
                if (value instanceof Vector) {
                    value = ((Vector)value).elementAt(0);
                }
                result = value.toString();
            }
            return result;
        }
        return super.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        if (this.values != null) {
            Object value = this.get(name);
            if (value != null) {
                if (value instanceof Vector) {
                    String[] results = new String[((Vector)value).size()];
                    for (int i = 0; i < ((Vector)value).size(); ++i) {
                        results[i] = ((Vector)value).elementAt(i).toString();
                    }
                    return results;
                }
                return new String[]{value.toString()};
            }
            return null;
        }
        return this.getRequest().getParameterValues(name);
    }
}

