/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet.multipart;

import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.servlet.RequestUtil;
import org.apache.cocoon.servlet.ServletSettings;
import org.apache.cocoon.servlet.multipart.MultipartConfigurationHelper;
import org.apache.cocoon.servlet.multipart.MultipartHttpServletRequest;
import org.apache.cocoon.servlet.multipart.RequestFactory;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class MultipartFilter
extends AbstractLogEnabled
implements Filter {
    protected RequestFactory requestFactory;
    protected BeanFactory cocoonBeanFactory;
    protected Settings settings;
    protected ServletSettings servletSettings;
    protected ServletContext servletContext;

    public void init(FilterConfig config) throws ServletException {
        this.servletContext = config.getServletContext();
    }

    public void destroy() {
    }

    protected synchronized void configure() {
        if (this.cocoonBeanFactory == null) {
            this.cocoonBeanFactory = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.servletContext);
            this.settings = (Settings)this.cocoonBeanFactory.getBean(Settings.ROLE);
            this.servletSettings = new ServletSettings(this.settings);
            String encoding = this.settings.getContainerEncoding();
            String containerEncoding = encoding == null ? "ISO-8859-1" : encoding;
            MultipartConfigurationHelper config = new MultipartConfigurationHelper();
            config.configure(this.settings, this.getLogger());
            this.requestFactory = new RequestFactory(config.isAutosaveUploads(), new File(config.getUploadDirectory()), config.isAllowOverwrite(), config.isSilentlyRename(), config.getMaxUploadSize(), containerEncoding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain filterChain) throws IOException, ServletException {
        if (this.cocoonBeanFactory == null) {
            this.configure();
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            try {
                request = this.requestFactory.getServletRequest(request);
            }
            catch (Exception e) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error((Object)"Problem in multipart filter. Unable to create request.", (Throwable)e);
                }
                RequestUtil.manageException(request, response, null, null, 500, "Problem in creating the Request", null, null, e, this.servletSettings, this.getLogger(), (Object)this);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (request instanceof MultipartHttpServletRequest) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)"Deleting uploaded file(s).");
                    }
                    ((MultipartHttpServletRequest)request).cleanup();
                }
            }
            catch (IOException e) {
                this.getLogger().error((Object)"MultipartFilter got an exception while trying to cleanup the uploaded files.", (Throwable)e);
            }
            throw throwable;
        }
        try {
            if (request instanceof MultipartHttpServletRequest) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"Deleting uploaded file(s).");
                }
                ((MultipartHttpServletRequest)request).cleanup();
            }
        }
        catch (IOException e) {
            this.getLogger().error((Object)"MultipartFilter got an exception while trying to cleanup the uploaded files.", (Throwable)e);
        }
    }
}

