/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cocoon.components.source.impl.CachingSource;
import org.apache.cocoon.components.source.impl.CachingSourceFactory;
import org.apache.cocoon.components.source.impl.CachingSourceValidityStrategy;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.TraversableSource;

public class TraversableCachingSource
extends CachingSource
implements TraversableSource {
    private CachingSourceFactory factory;

    public TraversableCachingSource(CachingSourceFactory factory, String protocol, String uri, String sourceUri, TraversableSource source, int expires, String cacheName, boolean async, CachingSourceValidityStrategy validityStrategy, boolean fail) {
        super(protocol, uri, sourceUri, (Source)source, expires, cacheName, async, validityStrategy, fail);
        this.factory = factory;
    }

    private TraversableSource getTraversableSource() {
        return (TraversableSource)this.source;
    }

    private TraversableSourceMeta getTraversableResponseMeta() throws IOException {
        return (TraversableSourceMeta)this.getResponseMeta();
    }

    public String getName() {
        try {
            return this.getTraversableResponseMeta().getName();
        }
        catch (IOException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Failure initializing traversable response", (Throwable)e);
            }
            return null;
        }
    }

    public boolean isCollection() {
        try {
            return this.getTraversableResponseMeta().isCollection();
        }
        catch (IOException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Failure initializing traversable response", (Throwable)e);
            }
            return false;
        }
    }

    public Source getChild(String name) throws SourceException {
        Source child;
        if (!this.isCollection()) {
            throw new SourceException("Source is not a collection");
        }
        try {
            this.getResponseMeta();
            child = this.getTraversableSource().getChild(name);
        }
        catch (SourceException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SourceException("Failure getting child", (Throwable)e);
        }
        boolean isCollection = false;
        if (child instanceof TraversableSource) {
            isCollection = ((TraversableSource)child).isCollection();
        }
        return this.createSource(TraversableCachingSource.getChildURI(this.uri, isCollection, name), TraversableCachingSource.getChildURI(this.sourceUri, isCollection, name), child);
    }

    public Collection getChildren() throws SourceException {
        TraversableSourceMeta meta;
        try {
            meta = this.getTraversableResponseMeta();
        }
        catch (SourceException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SourceException("Failure getting child", (Throwable)e);
        }
        if (!this.isCollection()) {
            throw new SourceException("Source is not a collection");
        }
        ArrayList<TraversableCachingSource> result = new ArrayList<TraversableCachingSource>();
        String[] children = meta.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Source child;
            try {
                child = this.getTraversableSource().getChild(children[i]);
            }
            catch (IOException e) {
                throw new SourceException("Failure getting child", (Throwable)e);
            }
            boolean isCollection = false;
            if (child instanceof TraversableSource) {
                isCollection = ((TraversableSource)child).isCollection();
            }
            result.add(this.createSource(TraversableCachingSource.getChildURI(this.uri, isCollection, children[i]), TraversableCachingSource.getChildURI(this.sourceUri, isCollection, children[i]), child));
        }
        return result;
    }

    public Source getParent() throws SourceException {
        Source parent;
        try {
            this.getResponseMeta();
            parent = this.getTraversableSource().getParent();
        }
        catch (SourceException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SourceException("Failure getting parent", (Throwable)e);
        }
        return this.createSource(TraversableCachingSource.getParentURI(this.uri), TraversableCachingSource.getParentURI(this.sourceUri), parent);
    }

    protected final TraversableCachingSource createSource(String uri, String wrappedUri, Source wrapped) throws SourceException {
        return (TraversableCachingSource)this.factory.createCachingSource(uri, wrappedUri, wrapped, this.expires, this.cacheName, this.fail);
    }

    protected CachingSource.SourceMeta readMeta(Source source) throws SourceException {
        return new TraversableSourceMeta(source);
    }

    private static String getChildURI(String parentURI, boolean isCollection, String childName) {
        String qs;
        String rest;
        int index = parentURI.indexOf(63);
        if (index != -1) {
            rest = parentURI.substring(0, index);
            qs = parentURI.substring(index);
        } else {
            rest = parentURI;
            qs = "";
        }
        StringBuffer childURI = new StringBuffer(rest);
        if (rest.charAt(rest.length() - 1) != '/') {
            childURI.append('/');
        }
        childURI.append(childName);
        if (isCollection) {
            childURI.append('/');
        }
        childURI.append(qs);
        return childURI.toString();
    }

    private static String getParentURI(String childURI) {
        String qs;
        String rest;
        int index = childURI.indexOf(63);
        if (index != -1) {
            rest = childURI.substring(0, index);
            qs = childURI.substring(index);
        } else {
            rest = childURI;
            qs = "";
        }
        index = rest.lastIndexOf(47, rest.length() - 2);
        String parentUri = index != -1 ? rest.substring(0, index + 1) : rest;
        return parentUri + qs;
    }

    protected static class TraversableSourceMeta
    extends CachingSource.SourceMeta {
        private String m_name;
        private boolean m_isCollection;
        private String[] m_children;

        public TraversableSourceMeta() {
        }

        public TraversableSourceMeta(Source source) throws SourceException {
            super(source);
            Collection children;
            TraversableSource tsource = (TraversableSource)source;
            this.setName(tsource.getName());
            this.setIsCollection(tsource.isCollection());
            if (this.isCollection() && (children = tsource.getChildren()) != null) {
                String[] names = new String[children.size()];
                Iterator iter = children.iterator();
                int count = 0;
                while (iter.hasNext()) {
                    TraversableSource child = (TraversableSource)iter.next();
                    names[count] = child.getName();
                    ++count;
                }
                this.setChildren(names);
            }
        }

        protected String getName() {
            return this.m_name;
        }

        protected void setName(String name) {
            this.m_name = name;
        }

        protected boolean isCollection() {
            return this.m_isCollection;
        }

        protected void setIsCollection(boolean isCollection) {
            this.m_isCollection = isCollection;
        }

        protected String[] getChildren() {
            return this.m_children;
        }

        protected void setChildren(String[] children) {
            this.m_children = children;
        }
    }
}

