/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.caching.Cache;
import org.apache.cocoon.components.source.helpers.SourceRefresher;
import org.apache.cocoon.components.source.impl.CachingSource;
import org.apache.cocoon.components.source.impl.CachingSourceValidityStrategy;
import org.apache.cocoon.components.source.impl.TraversableCachingSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.TraversableSource;
import org.apache.excalibur.source.URIAbsolutizer;
import org.springframework.beans.factory.BeanNameAware;

public class CachingSourceFactory
implements URIAbsolutizer,
SourceFactory,
BeanNameAware {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final boolean DEFAULT_ASYNC_VALUE = false;
    private static final int DEFAULT_EXPIRES_VALUE = -1;
    protected String scheme;
    protected boolean async = false;
    protected int defaultExpires = -1;
    protected CachingSourceValidityStrategy validityStrategy;
    protected Cache cache;
    protected SourceRefresher refresher;
    protected ServiceManager serviceManager;
    protected SourceResolver resolver;

    public Source getSource(String location, Map parameters) throws IOException {
        int index;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating source " + location));
        }
        if ((index = location.indexOf(58)) == -1) {
            throw new MalformedURLException("This Source requires a subprotocol to be specified.");
        }
        String uri = location.substring(index + 1);
        SourceParameters sp = null;
        index = uri.indexOf(63);
        if (index != -1) {
            sp = new SourceParameters(uri.substring(index + 1));
            uri = uri.substring(0, index);
        }
        Parameters params = new Parameters();
        if (sp != null) {
            SourceParameters remainingParameters = (SourceParameters)sp.clone();
            Iterator names = sp.getParameterNames();
            while (names.hasNext()) {
                String name = (String)names.next();
                if (!name.startsWith("cocoon:cache")) continue;
                params.setParameter(name.substring("cocoon:".length()), sp.getParameter(name));
                remainingParameters.removeParameter(name);
            }
            String queryString = remainingParameters.getEncodedQueryString();
            if (queryString != null) {
                uri = uri + "?" + queryString;
            }
        }
        int expires = params.getParameterAsInteger("cache-expires", this.defaultExpires);
        String cacheName = params.getParameter("cache-name", null);
        boolean fail = params.getParameterAsBoolean("cache-fail", false);
        return this.createCachingSource(location, uri, this.resolver.resolveURI(uri), expires, cacheName, fail);
    }

    protected CachingSource createCachingSource(String uri, String wrappedUri, Source wrappedSource, int expires, String cacheName, boolean fail) throws SourceException {
        CachingSource source = this.instantiateSource(uri, wrappedUri, wrappedSource, expires, cacheName, fail);
        source.cache = this.cache;
        try {
            ContainerUtil.service((Object)((Object)source), (ServiceManager)this.serviceManager);
            ContainerUtil.initialize((Object)((Object)source));
        }
        catch (ServiceException e) {
            throw new SourceException("Unable to initialize source.", (Throwable)e);
        }
        catch (Exception e) {
            throw new SourceException("Unable to initialize source.", (Throwable)e);
        }
        if (this.async && expires > 0) {
            Parameters params = new Parameters();
            params.setParameter("interval", String.valueOf(source.getExpiration()));
            if (this.refresher == null) {
                String msg = "Make sure that the SourceRefresher is injected correctly when you want to use the source asyncronous and with an expires param > 0.";
                this.logger.error((Object)msg);
                throw new SourceException(msg);
            }
            this.refresher.refresh(source.getCacheKey(), source.getURI(), params);
        }
        return source;
    }

    protected CachingSource instantiateSource(String uri, String wrappedUri, Source wrappedSource, int expires, String cacheName, boolean fail) {
        if (wrappedSource instanceof TraversableSource) {
            return new TraversableCachingSource(this, this.scheme, uri, wrappedUri, (TraversableSource)wrappedSource, expires, cacheName, this.async, this.validityStrategy, fail);
        }
        return new CachingSource(this.scheme, uri, wrappedUri, wrappedSource, expires, cacheName, this.async, this.validityStrategy, fail);
    }

    public void release(Source source) {
        if (source instanceof CachingSource) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Releasing source " + source.getURI()));
            }
            CachingSource caching = (CachingSource)source;
            this.resolver.release(caching.source);
            caching.dispose();
        }
    }

    public String absolutize(String baseURI, String location) {
        return SourceUtil.absolutize((String)baseURI, (String)location, (boolean)true);
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setValidityStrategy(CachingSourceValidityStrategy validityStrategy) {
        this.validityStrategy = validityStrategy;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public void setSourceResolver(SourceResolver resolver) {
        this.resolver = resolver;
    }

    public void setSourceRefresher(SourceRefresher refresher) {
        this.refresher = refresher;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setDefaultExpires(int expires) {
        this.defaultExpires = expires;
    }

    public void setBeanName(String beanName) {
        int pos = beanName.lastIndexOf(47);
        this.scheme = beanName.substring(pos + 1);
    }
}

