/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.script.event;

import java.util.Iterator;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.el.parsing.Subst;
import org.apache.cocoon.template.environment.ErrorHolder;
import org.apache.cocoon.template.environment.ExecutionContext;
import org.apache.cocoon.template.environment.ParsingContext;
import org.apache.cocoon.template.expression.Literal;
import org.apache.cocoon.template.expression.Substitutions;
import org.apache.cocoon.template.script.event.Event;
import org.apache.commons.lang.ArrayUtils;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TextEvent
extends Event {
    final Substitutions substitutions;
    final char[] raw;

    public TextEvent(ParsingContext parsingContext, Locator location, char[] chars, int start, int length) throws SAXException {
        super(location);
        this.raw = new char[length];
        System.arraycopy(chars, start, this.raw, 0, length);
        this.substitutions = new Substitutions(parsingContext.getStringTemplateParser(), this.getLocation(), chars, start, length);
    }

    public char[] getRaw() {
        return this.raw;
    }

    public Substitutions getSubstitutions() {
        return this.substitutions;
    }

    protected static void characters(ObjectModel objectModel, ExecutionContext executionContext, TextEvent event, CharHandler handler) throws SAXException {
        Iterator iter = event.getSubstitutions().iterator();
        while (iter.hasNext()) {
            char[] chars;
            Object subst = iter.next();
            if (subst instanceof Literal) {
                chars = ((Literal)subst).getCharArray();
            } else {
                Subst expr = (Subst)subst;
                try {
                    Object val = expr.getValue(objectModel);
                    chars = val != null ? val.toString().toCharArray() : ArrayUtils.EMPTY_CHAR_ARRAY;
                }
                catch (Exception e) {
                    throw new SAXParseException(e.getMessage(), event.getLocation(), e);
                }
                catch (Error err) {
                    throw new SAXParseException(err.getMessage(), event.getLocation(), new ErrorHolder(err));
                }
            }
            handler.characters(chars, 0, chars.length);
        }
    }

    static interface CharHandler {
        public void characters(char[] var1, int var2, int var3) throws SAXException;
    }
}

