/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.instruction;

import java.io.ByteArrayInputStream;
import java.util.Stack;
import org.apache.cocoon.core.xml.SAXParser;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.el.parsing.Subst;
import org.apache.cocoon.template.environment.ExecutionContext;
import org.apache.cocoon.template.environment.ParsingContext;
import org.apache.cocoon.template.instruction.Instruction;
import org.apache.cocoon.template.instruction.MacroContext;
import org.apache.cocoon.template.script.Invoker;
import org.apache.cocoon.template.script.event.Event;
import org.apache.cocoon.template.script.event.StartElement;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.util.NamespacesTable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.excalibur.xml.sax.XMLizable;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Out
extends Instruction {
    private final Subst compiledExpression;
    private Boolean xmlize;
    private Boolean stripRoot;

    public Out(ParsingContext parsingContext, StartElement raw, Attributes attrs, Stack stack) throws SAXException {
        super(raw);
        String xmlize;
        Boolean lenient;
        Locator locator = this.getLocation();
        String value = attrs.getValue("value");
        if (value == null) {
            throw new SAXParseException("out: \"value\" is required", locator, null);
        }
        this.compiledExpression = parsingContext.getStringTemplateParser().compileExpr(value, "out: \"value\": ", locator);
        String lenientValue = attrs.getValue("lenient");
        Boolean bl = lenient = lenientValue == null ? null : Boolean.valueOf(lenientValue);
        if (lenient != null) {
            this.compiledExpression.setLenient(lenient);
        }
        this.xmlize = (xmlize = attrs.getValue("xmlize")) == null ? null : Boolean.valueOf(xmlize);
        String stripRoot = attrs.getValue("strip-root");
        this.stripRoot = stripRoot == null ? null : Boolean.valueOf(stripRoot);
    }

    public Event execute(XMLConsumer consumer, ObjectModel objectModel, ExecutionContext executionContext, MacroContext macroContext, NamespacesTable namespaces, Event startEvent, Event endEvent) throws SAXException {
        try {
            Object val = this.compiledExpression.getNode(objectModel);
            boolean stripRoot = BooleanUtils.toBoolean((Boolean)this.stripRoot);
            if (BooleanUtils.isTrue((Boolean)this.xmlize)) {
                if (val instanceof Node || val instanceof Node[] || val instanceof XMLizable) {
                    Invoker.executeNode(consumer, val, stripRoot);
                } else {
                    SAXParser parser = executionContext.getSaxParser();
                    InputSource source = new InputSource(new ByteArrayInputStream(val.toString().getBytes()));
                    IncludeXMLConsumer includeConsumer = new IncludeXMLConsumer(consumer);
                    includeConsumer.setIgnoreRootElement(stripRoot);
                    parser.parse(source, (ContentHandler)includeConsumer);
                }
            } else {
                Invoker.executeNode(consumer, val, stripRoot);
            }
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), this.getLocation(), e);
        }
        return this.getNext();
    }
}

