/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.core.xml.SAXParser;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.el.parsing.Subst;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.objectmodel.helper.ParametersMap;
import org.apache.cocoon.template.environment.ExecutionContext;
import org.apache.cocoon.template.environment.JXCacheKey;
import org.apache.cocoon.template.environment.JXSourceValidity;
import org.apache.cocoon.template.script.Invoker;
import org.apache.cocoon.template.script.ScriptManager;
import org.apache.cocoon.template.script.event.Event;
import org.apache.cocoon.template.script.event.StartDocument;
import org.apache.cocoon.template.xml.AttributeAwareXMLConsumerImpl;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.cocoon.xml.RedundantNamespacesFilter;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.util.NamespacesTable;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.SAXException;

public class JXTemplateGenerator
extends AbstractLogEnabled
implements Generator,
CacheableProcessingComponent {
    public static final String NS = "http://apache.org/cocoon/templates/jx/1.0";
    public static final String CACHE_KEY = "cache-key";
    public static final String VALIDITY = "cache-validity";
    protected ObjectModel objectModel;
    protected NamespacesTable namespaces;
    protected ScriptManager scriptManager;
    protected StartDocument startDocument;
    protected Map definitions;
    protected SAXParser saxParser;
    protected XMLConsumer consumer;
    protected Parameters parameters;
    protected String src;

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public void setScriptManager(ScriptManager scriptManager) {
        this.scriptManager = scriptManager;
    }

    public SAXParser getSaxParser() {
        return this.saxParser;
    }

    public void setSaxParser(SAXParser saxParser) {
        this.saxParser = saxParser;
    }

    public ObjectModel getObjectModel() {
        return this.objectModel;
    }

    public void setObjectModel(ObjectModel objectModel) {
        this.objectModel = objectModel;
    }

    public void setConsumer(XMLConsumer consumer) {
        this.consumer = consumer;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.parameters = parameters;
        this.src = src;
        if (src != null) {
            this.startDocument = this.scriptManager.resolveTemplate(src);
        }
        this.namespaces = new NamespacesTable();
        this.definitions = new HashMap();
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.performGeneration(this.startDocument, null);
        this.startDocument = null;
    }

    public void performGeneration(Event startEvent, Event endEvent) throws SAXException {
        this.objectModel.markLocalContext();
        this.objectModel.putAt("cocoon/parameters", (Object)new ParametersMap(this.parameters));
        this.objectModel.put((Object)"namespace", (Object)this.namespaces);
        AttributeAwareXMLConsumerImpl consumer = new AttributeAwareXMLConsumerImpl((XMLConsumer)new RedundantNamespacesFilter(this.consumer));
        this.objectModel.putAt("cocoon/consumer", (Object)consumer);
        Invoker.execute(consumer, this.objectModel, new ExecutionContext(this.definitions, this.scriptManager, this.saxParser), null, this.namespaces, startEvent, null);
        this.objectModel.cleanupLocalContext();
    }

    public Serializable getKey() {
        Subst cacheKeyExpr = (Subst)this.startDocument.getTemplateProperty(CACHE_KEY);
        if (cacheKeyExpr == null) {
            return null;
        }
        try {
            Serializable templateKey = (Serializable)cacheKeyExpr.getValue(this.objectModel);
            if (templateKey != null) {
                return new JXCacheKey(this.startDocument.getUri(), templateKey);
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)"error evaluating cache key", (Throwable)e);
        }
        return null;
    }

    public SourceValidity getValidity() {
        Subst validityExpr = (Subst)this.startDocument.getTemplateProperty(VALIDITY);
        if (validityExpr == null) {
            return null;
        }
        try {
            SourceValidity sourceValidity = this.startDocument.getSourceValidity();
            SourceValidity templateValidity = (SourceValidity)validityExpr.getValue(this.objectModel);
            if (sourceValidity != null && templateValidity != null) {
                return new JXSourceValidity(sourceValidity, templateValidity);
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)"error evaluating cache validity", (Throwable)e);
        }
        return null;
    }
}

