/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.event;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.event.CacheEventListener;

public final class RegisteredEventListeners {
    private final Set cacheEventListeners = new HashSet();
    private final Ehcache cache;

    public RegisteredEventListeners(Ehcache cache) {
        this.cache = cache;
    }

    public final void notifyElementRemoved(Element element, boolean remoteEvent) throws CacheException {
        if (this.hasCacheEventListeners()) {
            Iterator iterator = this.cacheEventListeners.iterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementRemoved(this.cache, element);
            }
        }
    }

    public final void notifyElementPut(Element element, boolean remoteEvent) throws CacheException {
        if (this.hasCacheEventListeners()) {
            Iterator iterator = this.cacheEventListeners.iterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementPut(this.cache, element);
            }
        }
    }

    public final void notifyElementUpdated(Element element, boolean remoteEvent) {
        if (this.hasCacheEventListeners()) {
            Iterator iterator = this.cacheEventListeners.iterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementUpdated(this.cache, element);
            }
        }
    }

    public final void notifyElementExpiry(Element element, boolean remoteEvent) {
        if (this.hasCacheEventListeners()) {
            Iterator iterator = this.cacheEventListeners.iterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementExpired(this.cache, element);
            }
        }
    }

    public final boolean hasCacheEventListeners() {
        return this.cacheEventListeners.size() > 0;
    }

    public void notifyElementEvicted(Element element, boolean remoteEvent) {
        if (this.hasCacheEventListeners()) {
            Iterator iterator = this.cacheEventListeners.iterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementEvicted(this.cache, element);
            }
        }
    }

    public void notifyRemoveAll(boolean remoteEvent) {
        if (this.hasCacheEventListeners()) {
            Iterator iterator = this.cacheEventListeners.iterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyRemoveAll(this.cache);
            }
        }
    }

    private static boolean isCircularNotification(boolean remoteEvent, CacheEventListener cacheEventListener) {
        return remoteEvent && cacheEventListener instanceof CacheReplicator;
    }

    public final boolean registerListener(CacheEventListener cacheEventListener) {
        if (cacheEventListener == null) {
            return false;
        }
        return this.cacheEventListeners.add(cacheEventListener);
    }

    public final boolean unregisterListener(CacheEventListener cacheEventListener) {
        return this.cacheEventListeners.remove(cacheEventListener);
    }

    public final Set getCacheEventListeners() {
        return this.cacheEventListeners;
    }

    public final void dispose() {
        Iterator iterator = this.cacheEventListeners.iterator();
        while (iterator.hasNext()) {
            CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
            cacheEventListener.dispose();
        }
        this.cacheEventListeners.clear();
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(" cacheEventListeners: ");
        Iterator iterator = this.cacheEventListeners.iterator();
        while (iterator.hasNext()) {
            CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
            stringBuffer.append(cacheEventListener.getClass().getName()).append(" ");
        }
        return stringBuffer.toString();
    }
}

