/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.impl.AbstractSourceResolver;

public class SourceResolverImpl
extends AbstractSourceResolver
implements Serviceable,
Contextualizable,
Disposable,
LogEnabled,
ThreadSafe {
    protected ServiceManager m_manager;
    protected ServiceSelector m_factorySelector;
    private Logger m_logger;

    protected SourceFactory getSourceFactory(String protocol) {
        try {
            return (SourceFactory)this.m_factorySelector.select((Object)protocol);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    protected void releaseSourceFactory(SourceFactory factory) {
        this.m_factorySelector.release((Object)factory);
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    protected final Logger getLogger() {
        return this.m_logger;
    }

    protected final void debug(String text) {
        this.m_logger.debug(text);
    }

    protected final boolean isDebugEnabled() {
        return this.m_logger.isDebugEnabled();
    }

    public void contextualize(Context context) throws ContextException {
        try {
            this.m_baseURL = context.get((Object)"context-root") instanceof URL ? (URL)context.get((Object)"context-root") : ((File)context.get((Object)"context-root")).toURL();
        }
        catch (ContextException ce) {
            try {
                this.m_baseURL = new File(System.getProperty("user.dir")).toURL();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("SourceResolver: Using base URL: " + this.m_baseURL);
                }
            }
            catch (MalformedURLException mue) {
                this.getLogger().warn("Malformed URL for user.dir, and no container.rootDir exists", (Throwable)mue);
                throw new ContextException("Malformed URL for user.dir, and no container.rootDir exists", (Throwable)mue);
            }
        }
        catch (MalformedURLException mue) {
            this.getLogger().warn("Malformed URL for container.rootDir", (Throwable)mue);
            throw new ContextException("Malformed URL for container.rootDir", (Throwable)mue);
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.m_manager = manager;
        this.m_factorySelector = (ServiceSelector)this.m_manager.lookup(SourceFactory.ROLE + "Selector");
    }

    public void dispose() {
        if (null != this.m_manager) {
            this.m_manager.release((Object)this.m_factorySelector);
            this.m_factorySelector = null;
        }
    }
}

