/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.validation.impl;

import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.forms.validation.ConfigurableWidgetValidator;
import org.apache.cocoon.forms.validation.WidgetValidator;
import org.apache.cocoon.forms.validation.WidgetValidatorBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.w3c.dom.Element;

public class JavaClassValidatorBuilder
implements WidgetValidatorBuilder,
BeanFactoryAware {
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public WidgetValidator build(Element validationRuleElement, WidgetDefinition definition) throws Exception {
        if (DomHelper.getAttribute(validationRuleElement, "class", null) != null) {
            throw new RuntimeException("The 'class' attribute is not supported anymore at " + DomHelper.getLocationObject(validationRuleElement) + ". Use a 'ref' attribute to address a Spring bean");
        }
        String name = DomHelper.getAttribute(validationRuleElement, "ref");
        try {
            Object validator = this.beanFactory.getBean(name);
            if (validator instanceof WidgetValidator) {
                if (validator instanceof ConfigurableWidgetValidator) {
                    ((ConfigurableWidgetValidator)validator).setConfiguration(validationRuleElement);
                }
                return (WidgetValidator)validator;
            }
            throw new FormsException("Spring bean " + name + " is not a " + WidgetValidator.class.getName(), DomHelper.getLocationObject(validationRuleElement));
        }
        catch (BeansException be) {
            throw new FormsException("Spring bean " + name + " does not exist in Spring context", DomHelper.getLocationObject(validationRuleElement));
        }
    }
}

