/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.util;

import java.util.Iterator;
import java.util.Locale;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.formmodel.Action;
import org.apache.cocoon.forms.formmodel.AggregateField;
import org.apache.cocoon.forms.formmodel.BooleanField;
import org.apache.cocoon.forms.formmodel.ContainerWidget;
import org.apache.cocoon.forms.formmodel.DataWidget;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.formmodel.MultiValueField;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.xml.AbstractXMLConsumer;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLAdapter
extends AbstractXMLConsumer
implements XMLizable {
    private static final String ITEM = "item";
    private static final String UNKNOWN = "unknown";
    private static final String POSITION = "position";
    private static final String PREFIX = "";
    private static final String URI = "";
    private ContentHandler contentHandler;
    private Widget widget;
    private Widget currentWidget;
    private Locale locale;
    private boolean isMultiValueItem;
    private StringBuffer textBuffer;

    public XMLAdapter(Widget widget) {
        this.widget = widget;
        this.locale = Locale.US;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        this.handleText();
        if (this.currentWidget == null) {
            this.currentWidget = this.widget;
        } else if (this.currentWidget instanceof ContainerWidget) {
            Widget child = ((ContainerWidget)this.currentWidget).getChild(loc);
            if (child == null) {
                throw new SAXException("There is no widget with id: " + loc + " as child to: " + this.currentWidget.getId());
            }
            this.currentWidget = child;
        } else if (this.currentWidget instanceof Repeater) {
            if (!ITEM.equals(loc)) {
                throw new SAXException("The element: " + loc + " is not allowed as a direct child of a Repeater");
            }
            Repeater repeater = (Repeater)this.currentWidget;
            this.currentWidget = repeater.addRow();
        } else if (this.currentWidget instanceof MultiValueField) {
            this.isMultiValueItem = true;
            if (!ITEM.equals(loc)) {
                throw new SAXException("The element: " + loc + " is not allowed as a direct child of a MultiValueField");
            }
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        this.handleText();
        if (this.currentWidget == null) {
            throw new SAXException("Wrong state");
        }
        String id = this.currentWidget.getId();
        if (this.currentWidget instanceof Form) {
            this.currentWidget = null;
            return;
        }
        if (this.currentWidget instanceof AggregateField) {
            ((AggregateField)this.currentWidget).combineFields();
        } else if (this.currentWidget instanceof Repeater.RepeaterRow) {
            id = ITEM;
        } else if (this.currentWidget instanceof MultiValueField && loc.equals(ITEM)) {
            this.isMultiValueItem = false;
            return;
        }
        if (!loc.equals(id)) {
            throw new SAXException("Unexpected element, was: " + loc + " expected: " + id);
        }
        this.currentWidget = this.currentWidget.getParent();
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer();
        }
        this.textBuffer.append(ch, start, len);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleText() throws SAXException {
        if (this.textBuffer == null) {
            return;
        }
        String input = this.textBuffer.toString().trim();
        this.textBuffer = null;
        if (input.length() == 0) {
            return;
        }
        if (this.currentWidget instanceof MultiValueField && this.isMultiValueItem) {
            MultiValueField field = (MultiValueField)this.currentWidget;
            Datatype type = field.getDatatype();
            ConversionResult conv = type.convertFromString(input, this.locale);
            if (!conv.isSuccessful()) {
                throw new SAXException("Could not convert: " + input + " to " + type.getTypeClass());
            }
            Object[] values = (Object[])field.getValue();
            int valLen = values == null ? 0 : values.length;
            Object[] newValues = new Object[valLen + 1];
            for (int i = 0; i < valLen; ++i) {
                newValues[i] = values[i];
            }
            newValues[valLen] = conv.getResult();
            field.setValues(newValues);
            return;
        } else if (this.currentWidget instanceof DataWidget) {
            DataWidget data = (DataWidget)this.currentWidget;
            Datatype type = data.getDatatype();
            ConversionResult conv = type.convertFromString(input, this.locale);
            if (!conv.isSuccessful()) {
                throw new SAXException("Could not convert: " + input + " to " + type.getTypeClass());
            }
            data.setValue(conv.getResult());
            return;
        } else {
            if (!(this.currentWidget instanceof BooleanField)) throw new SAXException("Unknown widget type: " + this.currentWidget);
            if ("true".equals(input)) {
                this.currentWidget.setValue(Boolean.TRUE);
                return;
            } else {
                if (!"false".equals(input)) throw new SAXException("Unkown boolean: " + input);
                this.currentWidget.setValue(Boolean.FALSE);
            }
        }
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        this.contentHandler = handler;
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping("", "");
        this.generateSAX(this.widget);
        this.contentHandler.endPrefixMapping("");
        this.contentHandler.endDocument();
    }

    private void generateSAX(Widget widget) throws SAXException {
        this.generateSAX(widget, null);
    }

    private void generateSAX(Widget widget, String id) throws SAXException {
        if (widget instanceof Action) {
            return;
        }
        if (id == null) {
            id = widget.getId().length() == 0 ? UNKNOWN : widget.getId();
        }
        AttributesImpl attr = new AttributesImpl();
        if (widget instanceof Repeater.RepeaterRow) {
            this.attribute(attr, POSITION, widget.getId());
        }
        this.start(id, attr);
        if (widget instanceof MultiValueField) {
            Datatype datatype = ((MultiValueField)widget).getDatatype();
            Object[] values = (Object[])widget.getValue();
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    this.start(ITEM, attr);
                    this.data(datatype.convertToString(values[i], this.locale));
                    this.end(ITEM);
                }
            }
        } else if (widget instanceof DataWidget) {
            Datatype datatype = ((DataWidget)widget).getDatatype();
            if (widget.getValue() != null) {
                this.data(datatype.convertToString(widget.getValue(), this.locale));
            }
        } else if (widget instanceof BooleanField) {
            if (widget.getValue() != null) {
                this.data(widget.getValue().toString());
            }
        } else if (widget instanceof ContainerWidget) {
            Iterator children = ((ContainerWidget)widget).getChildren();
            while (children.hasNext()) {
                this.generateSAX((Widget)children.next());
            }
        } else if (widget instanceof Repeater) {
            Repeater repeater = (Repeater)widget;
            for (int i = 0; i < repeater.getSize(); ++i) {
                this.generateSAX(repeater.getRow(i), ITEM);
            }
        }
        this.end(id);
    }

    private void attribute(AttributesImpl attr, String name, String value) {
        attr.addAttribute("", name, name, "CDATA", value);
    }

    private void start(String name, AttributesImpl attr) throws SAXException {
        String qName = name;
        this.contentHandler.startElement("", name, qName, attr);
        attr.clear();
    }

    private void end(String name) throws SAXException {
        String qName = name;
        this.contentHandler.endElement("", name, qName);
    }

    private void data(String data) throws SAXException {
        this.contentHandler.characters(data.toCharArray(), 0, data.length());
    }
}

