/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.util;

import java.util.AbstractList;
import java.util.Map;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.util.ContainerWidgetAsMap;

public class RepeaterAsList
extends AbstractList {
    private Repeater repeater;
    private boolean lowerCase;

    public RepeaterAsList(Repeater repeater, boolean keysToLowerCase) {
        this.repeater = repeater;
        this.lowerCase = keysToLowerCase;
    }

    public RepeaterAsList(Repeater repeater) {
        this(repeater, false);
    }

    public Repeater getWidget() {
        return this.repeater;
    }

    public Widget getWidget(String path) {
        return this.repeater.lookupWidget(path);
    }

    public Object get(int index) {
        return new ContainerWidgetAsMap(this.repeater.getRow(index), this.lowerCase);
    }

    public int size() {
        return this.repeater.getSize();
    }

    public Object set(int index, Object o) {
        if (o == null) {
            throw new NullPointerException("Cannot set null to a repeater");
        }
        if (!(o instanceof Map)) {
            throw new IllegalArgumentException("Cannot set a '" + o.getClass().toString() + "' to a repeater");
        }
        ContainerWidgetAsMap result = new ContainerWidgetAsMap(this.repeater.getRow(index));
        result.putAll((Map)o);
        return result;
    }

    public void add(int index, Object o) {
        if (o == null) {
            throw new NullPointerException("Cannot add null to a repeater");
        }
        if (!(o instanceof Map)) {
            throw new IllegalArgumentException("Cannot add a '" + o.getClass().toString() + "' to a repeater");
        }
        Repeater.RepeaterRow row = this.repeater.addRow(index);
        new ContainerWidgetAsMap(row).putAll((Map)o);
    }

    public Object remove(int index) {
        ContainerWidgetAsMap result = new ContainerWidgetAsMap(this.repeater.getRow(index));
        this.repeater.removeRow(index);
        return result;
    }

    public void clear() {
        this.repeater.clear();
    }
}

