/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.util;

import java.util.Arrays;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class I18nMessage
implements XMLizable {
    private String key;
    private String catalogue;
    private String[] parameters;
    private boolean[] keys;

    public I18nMessage(String key) {
        this(key, (String)null);
    }

    public I18nMessage(String key, String catalogue) {
        this.key = key;
        this.catalogue = catalogue;
    }

    public I18nMessage(String key, String[] parameters) {
        this(key, parameters, (String)null);
    }

    public I18nMessage(String key, String[] parameters, String catalogue) {
        this.key = key;
        this.parameters = parameters;
        this.catalogue = catalogue;
    }

    public I18nMessage(String key, String[] parameters, boolean[] keys) {
        this(key, parameters, keys, null);
    }

    public I18nMessage(String key, String[] parameters, boolean[] keys, String catalogue) {
        this.key = key;
        this.parameters = parameters;
        this.keys = keys;
        this.catalogue = catalogue;
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        contentHandler.startPrefixMapping("i18n", "http://apache.org/cocoon/i18n/2.1");
        if (this.parameters != null) {
            contentHandler.startElement("http://apache.org/cocoon/i18n/2.1", "translate", "i18n:translate", XMLUtils.EMPTY_ATTRIBUTES);
        }
        AttributesImpl i18nAttrs = new AttributesImpl();
        if (this.catalogue != null) {
            i18nAttrs.addCDATAAttribute("http://apache.org/cocoon/i18n/2.1", "catalogue", "i18n:catalogue", this.catalogue);
        }
        contentHandler.startElement("http://apache.org/cocoon/i18n/2.1", "text", "i18n:text", (Attributes)i18nAttrs);
        contentHandler.characters(this.key.toCharArray(), 0, this.key.length());
        contentHandler.endElement("http://apache.org/cocoon/i18n/2.1", "text", "i18n:text");
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.length; ++i) {
                contentHandler.startElement("http://apache.org/cocoon/i18n/2.1", "param", "i18n:param", XMLUtils.EMPTY_ATTRIBUTES);
                if (this.keys != null && this.keys[i]) {
                    contentHandler.startElement("http://apache.org/cocoon/i18n/2.1", "text", "i18n:text", (Attributes)i18nAttrs);
                }
                String aParam = String.valueOf(this.parameters[i]);
                contentHandler.characters(aParam.toCharArray(), 0, aParam.length());
                if (this.keys != null && this.keys[i]) {
                    contentHandler.endElement("http://apache.org/cocoon/i18n/2.1", "text", "i18n:text");
                }
                contentHandler.endElement("http://apache.org/cocoon/i18n/2.1", "param", "i18n:param");
            }
            contentHandler.endElement("http://apache.org/cocoon/i18n/2.1", "translate", "i18n:translate");
        }
        contentHandler.endPrefixMapping("i18n");
    }

    public boolean equals(Object obj) {
        if (obj instanceof I18nMessage) {
            I18nMessage other = (I18nMessage)obj;
            return ObjectUtils.equals((Object)this.catalogue, (Object)other.catalogue) && ObjectUtils.equals((Object)this.key, (Object)other.key) && Arrays.equals(this.keys, other.keys) && Arrays.equals(this.parameters, other.parameters);
        }
        return false;
    }
}

