/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.cocoon.forms.formmodel.AbstractContainerWidget;
import org.apache.cocoon.forms.formmodel.ContainerWidget;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.util.RepeaterAsList;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;

public class ContainerWidgetAsMap
extends AbstractMap {
    protected AbstractContainerWidget container;
    private boolean lowerCase;

    public ContainerWidgetAsMap(AbstractContainerWidget container, boolean keysToLowerCase) {
        this.container = container;
        this.lowerCase = keysToLowerCase;
    }

    public ContainerWidgetAsMap(AbstractContainerWidget container) {
        this(container, false);
    }

    public ContainerWidget getWidget() {
        return this.container;
    }

    public Widget getWidget(String path) {
        return this.container.lookupWidget(path);
    }

    public Object put(Object key, Object value) {
        Widget w;
        String name = (String)key;
        if (this.lowerCase) {
            name = name.toLowerCase();
        }
        if ((w = this.container.getChild(name)) != null) {
            return this.setValue(w, value);
        }
        throw new UnsupportedOperationException(this.container + " has no child named '" + key + "'");
    }

    public void putAll(Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Widget w;
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            if (this.lowerCase) {
                name = name.toLowerCase();
            }
            if ((w = this.container.getChild(name)) == null) continue;
            this.setValue(w, entry.getValue());
        }
    }

    public Object get(Object key) {
        Widget w;
        String name = (String)key;
        if (this.lowerCase) {
            name = name.toLowerCase();
        }
        return (w = this.container.getChild(name)) == null ? null : this.asValueOrMap(w);
    }

    public Set entrySet() {
        return new ContainerEntrySet();
    }

    private Object asValueOrMap(Widget w) {
        if (w instanceof Repeater) {
            return new RepeaterAsList((Repeater)w, this.lowerCase);
        }
        if (w instanceof AbstractContainerWidget) {
            return new ContainerWidgetAsMap((AbstractContainerWidget)w, this.lowerCase);
        }
        try {
            return w.getValue();
        }
        catch (UnsupportedOperationException uoe) {
            return null;
        }
    }

    private Object setValue(Widget w, Object value) {
        if (w instanceof Repeater) {
            if (!(value instanceof Collection)) {
                throw new IllegalArgumentException("A repeater cannot be filled with " + value);
            }
            RepeaterAsList result = new RepeaterAsList((Repeater)w, this.lowerCase);
            result.addAll((Collection)value);
            return result;
        }
        if (w instanceof AbstractContainerWidget) {
            if (!(value instanceof Map)) {
                throw new IllegalArgumentException("A container cannot be filled with " + value);
            }
            ContainerWidgetAsMap result = new ContainerWidgetAsMap((AbstractContainerWidget)w);
            result.putAll((Map)value);
            return result;
        }
        try {
            Object result = w.getValue();
            w.setValue(value);
            return result;
        }
        catch (UnsupportedOperationException uoe) {
            return null;
        }
    }

    private class ContainerEntry
    implements Map.Entry {
        Widget widget;

        public ContainerEntry(Widget w) {
            this.widget = w;
        }

        public Object getKey() {
            return this.widget.getName();
        }

        public Object getValue() {
            return ContainerWidgetAsMap.this.asValueOrMap(this.widget);
        }

        public Object setValue(Object value) {
            Object result = ContainerWidgetAsMap.this.asValueOrMap(this.widget);
            ContainerWidgetAsMap.this.setValue(this.widget, value);
            return result;
        }
    }

    private class ContainerEntryIterator
    extends AbstractIteratorDecorator {
        public ContainerEntryIterator() {
            super(ContainerWidgetAsMap.this.container.getChildren());
        }

        public Object next() {
            return new ContainerEntry((Widget)super.next());
        }
    }

    private class ContainerEntrySet
    extends AbstractSet {
        private ContainerEntrySet() {
        }

        public Iterator iterator() {
            return new ContainerEntryIterator();
        }

        public int size() {
            return ContainerWidgetAsMap.this.container.getSize();
        }
    }
}

