/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CombiningMap
extends AbstractMap {
    protected List maps = new ArrayList();
    private boolean locked = false;

    public CombiningMap add(Map map) {
        if (this.locked) {
            throw new IllegalStateException("Cannot add new Maps to a CombiningMap once it has been iterated");
        }
        this.maps.add(map);
        return this;
    }

    public Object get(Object key) {
        for (int i = 0; i < this.maps.size(); ++i) {
            Map map = (Map)this.maps.get(i);
            Object result = map.get(key);
            if (result != null) {
                return result;
            }
            if (!map.containsKey(key)) continue;
            return null;
        }
        return null;
    }

    public boolean containsKey(Object key) {
        for (int i = 0; i < this.maps.size(); ++i) {
            Map map = (Map)this.maps.get(i);
            if (!map.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        this.locked = true;
        return new CombiningEntrySet();
    }

    private class CombiningIterator
    implements Iterator {
        private int index;
        private Iterator delegate;
        private Map.Entry next;

        public CombiningIterator() {
            if (!CombiningMap.this.maps.isEmpty()) {
                this.delegate = ((Map)CombiningMap.this.maps.get(0)).entrySet().iterator();
                if (this.delegate.hasNext()) {
                    this.next = (Map.Entry)this.delegate.next();
                }
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Map.Entry result = this.next;
            this.fetchNext();
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void fetchNext() {
            while (true) {
                if (this.delegate != null && !this.delegate.hasNext()) {
                    ++this.index;
                    if (this.index < CombiningMap.this.maps.size()) {
                        this.delegate = ((Map)CombiningMap.this.maps.get(this.index)).entrySet().iterator();
                        continue;
                    }
                    this.next = null;
                    this.delegate = null;
                    return;
                }
                this.next = (Map.Entry)this.delegate.next();
                Object key = this.next.getKey();
                boolean skip = false;
                for (int i = 0; i < this.index - 1; ++i) {
                    if (!((Map)CombiningMap.this.maps.get(i)).containsKey(key)) continue;
                    skip = true;
                }
                if (!skip) break;
            }
        }
    }

    private class CombiningEntrySet
    extends AbstractSet {
        private CombiningEntrySet() {
        }

        public Iterator iterator() {
            return new CombiningIterator();
        }

        public int size() {
            int size = 0;
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                ++size;
                iter.next();
            }
            return size;
        }
    }
}

