/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.generation;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.flow.ContinuationsManager;
import org.apache.cocoon.components.flow.InvalidContinuationException;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.cocoon.components.flow.javascript.fom.FOM_Cocoon;
import org.apache.cocoon.components.flow.javascript.fom.FOM_JavaScriptFlowHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.forms.datatype.FilterableSelectionList;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.formmodel.Field;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.generation.SelectionListFilter;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.sitemap.SitemapParameters;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.continuations.Continuation;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SuggestionListGenerator
extends ServiceableGenerator
implements Contextualizable {
    private ContinuationsManager contManager;
    private WebContinuation wk;
    private SelectionList list;
    private String filter;
    private Locale locale;
    private Context context;

    public void contextualize(Context ctx) throws ContextException {
        this.context = ctx;
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.contManager = (ContinuationsManager)manager.lookup(ContinuationsManager.ROLE);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        Request req = ObjectModelHelper.getRequest((Map)objectModel);
        String continuationId = par.getParameter("continuation-id", req.getParameter("continuation-id"));
        String widgetPath = par.getParameter("widget", req.getParameter("widget")).replace('.', '/');
        this.filter = par.getParameter("filter", req.getParameter("filter"));
        String interpreterId = SitemapParameters.getLocation((Parameters)this.parameters).getURI();
        this.wk = this.contManager.lookupWebContinuation(continuationId, interpreterId);
        if (this.wk == null || this.wk.disposed()) {
            throw new InvalidContinuationException("Cannot get continuation for suggestion list");
        }
        Form form = (Form)this.wk.getAttribute("form");
        if (form == null) {
            throw new ProcessingException("No form is attached to the continuation");
        }
        this.locale = form.getLocale();
        Field field = (Field)form.lookupWidget(widgetPath);
        this.list = field.getSuggestionList();
        if (this.list == null) {
            throw new ProcessingException(field + " has no suggestion list");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws IOException, SAXException, ProcessingException {
        block8: {
            this.contentHandler.startDocument();
            this.contentHandler.startPrefixMapping("fi", "http://apache.org/cocoon/forms/1.0#instance");
            if (this.filter == null || this.filter.length() == 0 || this.list instanceof FilterableSelectionList) {
                ContentHandler contentHandler = this.contentHandler;
            } else {
                SelectionListFilter selectionListFilter = new SelectionListFilter(this.filter, this.contentHandler);
            }
            Scriptable oldScope = null;
            FOM_Cocoon cocoon = null;
            if (this.wk.getContinuation() instanceof Continuation) {
                oldScope = FOM_JavaScriptFlowHelper.getFOM_FlowScope((Map)this.objectModel);
                Continuation k = (Continuation)this.wk.getContinuation();
                Scriptable kScope = k.getParentScope();
                FOM_JavaScriptFlowHelper.setFOM_FlowScope((Map)this.objectModel, (Scriptable)kScope);
                cocoon = (FOM_Cocoon)kScope.get("cocoon", kScope);
                cocoon.pushCallContext(null, null, this.context, this.wk);
            }
            try {
                void var1_3;
                if (this.list instanceof FilterableSelectionList) {
                    ((FilterableSelectionList)this.list).generateSaxFragment((ContentHandler)var1_3, this.locale, this.filter);
                } else {
                    this.list.generateSaxFragment((ContentHandler)var1_3, this.locale);
                }
                Object var7_8 = null;
                if (oldScope == null) break block8;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (oldScope != null) {
                    FOM_JavaScriptFlowHelper.setFOM_FlowScope((Map)this.objectModel, (Scriptable)oldScope);
                    cocoon.popCallContext();
                }
                throw throwable;
            }
            FOM_JavaScriptFlowHelper.setFOM_FlowScope((Map)this.objectModel, (Scriptable)oldScope);
            cocoon.popCallContext();
        }
        this.contentHandler.endPrefixMapping("fi");
        this.contentHandler.endDocument();
    }
}

