/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel.tree.builder;

import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.formmodel.AbstractWidgetDefinitionBuilder;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinitionBuilderContext;
import org.apache.cocoon.forms.formmodel.tree.TreeDefinition;
import org.apache.cocoon.forms.formmodel.tree.TreeSelectionListener;
import org.apache.cocoon.forms.formmodel.tree.builder.TreeModelDefinitionBuilder;
import org.apache.cocoon.forms.util.DomHelper;
import org.w3c.dom.Element;

public class TreeDefinitionBuilder
extends AbstractWidgetDefinitionBuilder {
    private Map treeModelDefinitionBuilders;

    public WidgetDefinition buildWidgetDefinition(Element widgetElement, WidgetDefinitionBuilderContext context) throws Exception {
        TreeDefinition definition = new TreeDefinition();
        this.setupDefinition(widgetElement, definition, context);
        definition.makeImmutable();
        return definition;
    }

    protected void setupDefinition(Element widgetElement, TreeDefinition definition, WidgetDefinitionBuilderContext context) throws Exception {
        String type;
        TreeModelDefinitionBuilder builder;
        Element modelElt;
        super.setupDefinition(widgetElement, definition, context);
        definition.setRootVisible(DomHelper.getAttributeAsBoolean(widgetElement, "root-visible", true));
        String selection = DomHelper.getAttribute(widgetElement, "selection", null);
        if (selection != null) {
            if ("multiple".equals(selection)) {
                definition.setSelectionModel(1);
            } else if ("single".equals(selection)) {
                definition.setSelectionModel(0);
            } else {
                throw new FormsException("Invalid value selection value '" + selection + "'.", DomHelper.getLocationObject(widgetElement));
            }
        }
        if ((modelElt = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "tree-model", false)) != null && (builder = (TreeModelDefinitionBuilder)this.treeModelDefinitionBuilders.get(type = DomHelper.getAttribute(modelElt, "type"))) != null) {
            definition.setModelDefinition(builder.build(modelElt));
        }
        Iterator i = this.buildEventListeners(widgetElement, "on-selection-changed", TreeSelectionListener.class).iterator();
        while (i.hasNext()) {
            definition.addSelectionListener((TreeSelectionListener)i.next());
        }
    }

    public void setTreeModelDefinitionBuilders(Map treeModelDefinitionBuilders) {
        this.treeModelDefinitionBuilders = treeModelDefinitionBuilders;
    }
}

