/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel.tree;

import java.util.Collections;
import java.util.Iterator;
import org.apache.cocoon.forms.formmodel.tree.Tree;
import org.apache.cocoon.forms.formmodel.tree.TreePath;
import org.apache.commons.collections.ArrayStack;

public class TreeWalker
implements Iterator {
    ArrayStack stack = new ArrayStack();
    Tree tree;
    Object node;
    TreePath path;
    Iterator iter = Collections.EMPTY_LIST.iterator();

    public TreeWalker(Tree tree) {
        this.tree = tree;
        this.node = tree.getModel().getRoot();
        this.path = TreePath.ROOT_PATH;
        this.stack.push((Object)this.iter);
        this.stack.push(this.node);
    }

    public TreeWalker enterChildren() {
        Iterator newIter = this.isLeaf() ? Collections.EMPTY_LIST.iterator() : this.tree.getModel().getChildren(this.node).iterator();
        this.stack.push((Object)this.iter);
        this.stack.push((Object)this.path);
        this.stack.push(this.node);
        this.iter = newIter;
        this.node = null;
        this.path = null;
        return this;
    }

    public void leave() {
        this.node = this.stack.pop();
        this.path = (TreePath)this.stack.pop();
        this.iter = (Iterator)this.stack.pop();
        this.path = this.path.getParentPath();
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public Object next() {
        this.node = this.iter.next();
        this.path = new TreePath((TreePath)this.stack.peek(1), this.tree.getModel().getChildKey(this.stack.peek(), this.node));
        return this.node;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int getDepth() {
        return this.path.getPathCount() - (this.tree.isRootVisible() ? 1 : 2);
    }

    public Object getNode() {
        return this.node;
    }

    public TreePath getPath() {
        return this.path;
    }

    public boolean isLeaf() {
        return this.tree.getModel().isLeaf(this.node);
    }

    public boolean isExpanded() {
        return this.tree.isExpanded(this.path);
    }

    public boolean isCollapsed() {
        return this.tree.isCollapsed(this.path);
    }

    public boolean isVisible() {
        return this.tree.isVisible(this.path);
    }

    public boolean isSelected() {
        return this.tree.isPathSelected(this.path);
    }

    public String getIconType() {
        if (this.isLeaf()) {
            return "leaf";
        }
        if (this.isExpanded()) {
            return "expanded";
        }
        return "collapsed";
    }

    public String getSelectionType() {
        return this.tree.isPathSelected(this.path) ? "selected" : "unselected";
    }
}

