/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel.tree;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.formmodel.tree.DefaultTreeModel;
import org.apache.cocoon.forms.formmodel.tree.TreeDefinition;
import org.apache.cocoon.forms.formmodel.tree.TreeModel;
import org.apache.cocoon.forms.formmodel.tree.TreeModelEvent;
import org.apache.cocoon.forms.formmodel.tree.TreeModelListener;
import org.apache.cocoon.forms.formmodel.tree.TreePath;
import org.apache.cocoon.forms.formmodel.tree.TreeSelectionEvent;
import org.apache.cocoon.forms.formmodel.tree.TreeSelectionListener;
import org.apache.cocoon.forms.formmodel.tree.TreeWalker;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Tree
extends AbstractWidget {
    public static final int SINGLE_SELECTION = 0;
    public static final int MULTIPLE_SELECTION = 1;
    private TreeDefinition treeDef;
    private TreeModel treeModel;
    private Set expandedPaths = new HashSet();
    private Set selectedPaths = new HashSet();
    private Set changedPaths = new HashSet();
    private HashMap pathWidgets = new HashMap();
    private boolean rootVisible = true;
    private boolean expandSelectedPath = false;
    private TreeSelectionListener selectionListener;
    private int selectionModel = 1;
    private TreeModelListener modelListener = new TreeModelListener(){

        public void treeStructureChanged(TreeModelEvent event) {
            Tree.this.markForRefresh(event.getPath());
        }
    };

    protected Tree(TreeDefinition definition) {
        super(definition);
        this.treeDef = definition;
        this.rootVisible = definition.isRootVisible();
        if (!this.rootVisible) {
            this.expandedPaths.add(TreePath.ROOT_PATH);
        }
        this.treeModel = definition.createModel();
        this.treeModel.addTreeModelListener(this.modelListener);
        this.selectionListener = definition.getSelectionListener();
        this.selectionModel = definition.getSelectionModel();
    }

    public WidgetDefinition getDefinition() {
        return this.treeDef;
    }

    protected String getXMLElementName() {
        return "tree";
    }

    protected void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        throw new UnsupportedOperationException(this + " cannot be rendered using <ft:widget>. Please use <ft:tree>.");
    }

    public void readFromRequest(FormContext formContext) {
        String action;
        String paramName;
        Request req = formContext.getRequest();
        String[] selectValues = req.getParameterValues((paramName = this.getRequestParameterName()) + ":select");
        if (selectValues != null) {
            HashSet<TreePath> newSelection = new HashSet<TreePath>();
            for (int i = 0; i < selectValues.length; ++i) {
                newSelection.add(TreePath.valueOf(selectValues[i]));
            }
            TreePath[] currentSelection = this.selectedPaths.toArray(new TreePath[this.selectedPaths.size()]);
            for (int i = 0; i < currentSelection.length; ++i) {
                TreePath p = currentSelection[i];
                if (newSelection.contains(p) || !this.isVisible(p)) continue;
                this.removeSelectionPath(p);
            }
            Iterator iter = newSelection.iterator();
            while (iter.hasNext()) {
                this.addSelectionPath((TreePath)iter.next());
            }
        }
        if ((action = req.getParameter(paramName + ":action")) == null || action.length() == 0) {
            return;
        }
        this.getForm().setSubmitWidget(this);
        String pathValue = req.getParameter(paramName + ":path");
        if (pathValue == null || pathValue.length() == 0) {
            return;
        }
        TreePath path = TreePath.valueOf(pathValue);
        if ("expand".equals(action)) {
            this.expandPath(path);
        } else if ("collapse".equals(action)) {
            this.collapsePath(path);
        } else if ("toggle-collapse".equals(action)) {
            if (this.isExpanded(path)) {
                this.collapsePath(path);
            } else {
                this.expandPath(path);
            }
        } else if ("select".equals(action)) {
            this.addSelectionPath(path);
        } else if ("unselect".equals(action)) {
            this.removeSelectionPath(path);
        } else if ("toggle-select".equals(action)) {
            if (this.isPathSelected(path)) {
                this.removeSelectionPath(path);
            } else {
                this.addSelectionPath(path);
            }
        }
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public void setModel(TreeModel model) {
        if (model == null) {
            model = DefaultTreeModel.UNSPECIFIED_MODEL;
        }
        this.treeModel.removeTreeModelListener(this.modelListener);
        this.treeModel = model;
        model.addTreeModelListener(this.modelListener);
    }

    private void markForRefresh(TreePath path) {
        this.changedPaths.add(path);
        this.getForm().addWidgetUpdate(this);
    }

    public void setSelectionModel(int model) {
        if (model < 0 || model > 1) {
            throw new IllegalArgumentException("Illegal selection model " + model);
        }
        if (model == this.selectionModel) {
            return;
        }
        this.selectionModel = model;
        if (model == 0 && this.getSelectionCount() > 1) {
            this.clearSelection();
        }
    }

    public int getSelectionCount() {
        return this.selectedPaths.size();
    }

    public TreePath getSelectionPath() {
        if (this.selectedPaths.isEmpty()) {
            return null;
        }
        return (TreePath)this.selectedPaths.iterator().next();
    }

    public TreePath[] getSelectionPaths() {
        return this.selectedPaths.toArray(new TreePath[this.selectedPaths.size()]);
    }

    public boolean isPathSelected(TreePath path) {
        return this.selectedPaths.contains(path);
    }

    public boolean isSelectionEmpty() {
        return this.selectedPaths.isEmpty();
    }

    public void setSelectionPath(TreePath path) {
        this.clearSelection();
        this.addSelectionPath(path);
    }

    public void setSelectionPaths(TreePath[] paths) {
        this.clearSelection();
        this.addSelectionPaths(paths);
    }

    public void addSelectionPath(TreePath path) {
        if (this.selectionModel == 0) {
            this.clearSelection();
        }
        if (this.selectedPaths.add(path)) {
            this.markForRefresh(path);
            if (this.expandSelectedPath) {
                this.expandPath(path);
            }
            this.getForm().addWidgetEvent(new TreeSelectionEvent(this, path, true));
        }
    }

    public void addSelectionPaths(TreePath[] paths) {
        if (this.selectionModel == 0) {
            this.setSelectionPath(paths[0]);
        } else {
            for (int i = 0; i < paths.length; ++i) {
                this.addSelectionPath(paths[i]);
            }
        }
    }

    public void removeSelectionPath(TreePath path) {
        if (this.selectedPaths.remove(path)) {
            this.markForRefresh(path.getParentPath());
            this.getForm().addWidgetEvent(new TreeSelectionEvent(this, path, false));
        }
    }

    public void removeSelectionPaths(TreePath[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            this.removeSelectionPath(paths[i]);
        }
    }

    public void clearSelection() {
        if (this.isSelectionEmpty()) {
            return;
        }
        TreePath[] paths = this.selectedPaths.toArray(new TreePath[this.selectedPaths.size()]);
        for (int i = 0; i < paths.length; ++i) {
            this.markForRefresh(paths[i].getParentPath());
        }
        this.selectedPaths.clear();
        this.getForm().addWidgetEvent(new TreeSelectionEvent(this, paths, false));
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.selectionListener = WidgetEventMulticaster.add(this.selectionListener, listener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener listener) {
        this.selectionListener = WidgetEventMulticaster.remove(this.selectionListener, listener);
    }

    public boolean isCollapsed(TreePath path) {
        return !this.isExpanded(path);
    }

    public boolean isExpanded(TreePath path) {
        if (this.expandedPaths.contains(path)) {
            TreePath parent = path.getParentPath();
            return parent == null ? true : this.isExpanded(parent);
        }
        return false;
    }

    public boolean isVisible(TreePath path) {
        if (path == TreePath.ROOT_PATH) {
            return true;
        }
        if (path != null) {
            TreePath parent = path.getParentPath();
            if (parent != null) {
                return this.isExpanded(parent);
            }
            return true;
        }
        return false;
    }

    public void makeVisible(TreePath path) {
        TreePath parent;
        if (path != null && (parent = path.getParentPath()) != null) {
            this.expandPath(parent);
            this.makeVisible(parent);
        }
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setRootVisible(boolean visible) {
        if (this.rootVisible != visible) {
            this.markForRefresh(TreePath.ROOT_PATH);
            this.rootVisible = visible;
            if (!visible) {
                this.expandPath(TreePath.ROOT_PATH);
            }
        }
    }

    public void collapsePath(TreePath path) {
        if (path != null && this.expandedPaths.remove(path)) {
            this.markForRefresh(path);
        }
    }

    public void expandPath(TreePath path) {
        if (path != null && this.expandedPaths.add(path)) {
            this.markForRefresh(path);
        }
    }

    public void collapseAll() {
        this.expandedPaths.clear();
        if (!this.rootVisible) {
            this.expandedPaths.add(TreePath.ROOT_PATH);
        }
    }

    public void expandAll() {
        this.collapseAll();
        this.expandedPaths.add(TreePath.ROOT_PATH);
        TreeWalker tw = new TreeWalker(this);
        tw.enterChildren();
        while (tw.hasNext()) {
            tw.next();
            if (!tw.isLeaf()) {
                this.expandPath(tw.getPath());
                tw.enterChildren();
            }
            if (tw.hasNext()) continue;
            tw.leave();
        }
    }

    public void setExpandsSelectedPath(boolean value) {
        this.expandSelectedPath = value;
    }

    public Widget getWidgetForPath(TreePath path) {
        Widget result = (Widget)this.pathWidgets.get(path);
        if (result == null && !this.pathWidgets.containsKey(path)) {
            result = this.createWidgetForPath(path);
            if (result != null) {
                result.setAttribute("TreePath", path);
            }
            this.pathWidgets.put(path, result);
        }
        return result;
    }

    private Widget createWidgetForPath(TreePath path) {
        return null;
    }

    public void broadcastEvent(WidgetEvent event) {
        if (event instanceof TreeSelectionEvent) {
            if (this.selectionListener != null) {
                this.selectionListener.selectionChanged((TreeSelectionEvent)event);
            }
        } else {
            super.broadcastEvent(event);
        }
    }

    public static interface ActionHandler {
        public void act(Tree var1, FormContext var2);
    }
}

