/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel.library;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinitionBuilder;
import org.apache.cocoon.forms.formmodel.WidgetDefinitionBuilderContext;
import org.apache.cocoon.forms.formmodel.library.LibraryException;
import org.apache.cocoon.forms.formmodel.library.LibraryManager;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.util.location.LocationAttributes;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class Library {
    private static Log LOG = LogFactory.getLog((Class)Library.class);
    public static final String SEPARATOR = ":";
    protected Map widgetDefinitionBuilders;
    protected LibraryManager manager;
    protected Map definitions = new HashMap();
    protected Map inclusions = new HashMap();
    protected final Object shared = new Object();
    protected String sourceURI;

    public Library(LibraryManager lm, Map builders) {
        this.manager = lm;
        this.widgetDefinitionBuilders = builders;
    }

    public void setSourceURI(String uri) {
        this.sourceURI = uri;
    }

    public String getSourceURI() {
        return this.sourceURI;
    }

    public boolean dependenciesHaveChanged() throws LibraryException {
        Iterator i = this.inclusions.values().iterator();
        while (i.hasNext()) {
            Dependency dep = (Dependency)i.next();
            if (dep.isValid()) continue;
            return true;
        }
        return false;
    }

    public boolean includeAs(String key, String sourceURI) throws LibraryException {
        if (!this.inclusions.containsKey(key) || key.indexOf(SEPARATOR) > -1) {
            this.manager.load(sourceURI, this.sourceURI);
            this.inclusions.put(key, new Dependency(sourceURI));
            return true;
        }
        return false;
    }

    public WidgetDefinition getDefinition(String key) throws LibraryException {
        String librarykey = null;
        String definitionkey = key;
        if (key.indexOf(SEPARATOR) > -1) {
            String[] parts = StringUtils.split((String)key, (String)SEPARATOR);
            librarykey = parts[0];
            definitionkey = parts[1];
            for (int i = 2; i < parts.length; ++i) {
                definitionkey = definitionkey + SEPARATOR + parts[i];
            }
        }
        if (librarykey != null) {
            Dependency dependency = (Dependency)this.inclusions.get(librarykey);
            if (dependency != null) {
                try {
                    return this.manager.load(dependency.dependencyURI, this.sourceURI).getDefinition(definitionkey);
                }
                catch (Exception e) {
                    throw new LibraryException("Couldn't get library '" + librarykey + "' source='" + dependency + "'", e);
                }
            }
            throw new LibraryException("Library '" + librarykey + "' does not exist! (lookup: '" + key + "')");
        }
        return (WidgetDefinition)this.definitions.get(definitionkey);
    }

    public void buildLibrary(Element libraryElement) throws Exception {
        this.sourceURI = LocationAttributes.getURI((Element)libraryElement);
        Element widgetsElement = DomHelper.getChildElement(libraryElement, "http://apache.org/cocoon/forms/1.0#definition", "widgets", true);
        WidgetDefinitionBuilderContext context = new WidgetDefinitionBuilderContext(this);
        Element[] widgetElements = DomHelper.getChildElements(widgetsElement, "http://apache.org/cocoon/forms/1.0#definition");
        for (int i = 0; i < widgetElements.length; ++i) {
            Element widgetElement = widgetElements[i];
            this.buildWidgetDefinition(widgetElement, context);
        }
    }

    private void buildWidgetDefinition(Element widgetDefinition, WidgetDefinitionBuilderContext context) throws Exception {
        String widgetName = widgetDefinition.getLocalName();
        WidgetDefinitionBuilder builder = (WidgetDefinitionBuilder)this.widgetDefinitionBuilders.get(widgetName);
        if (builder == null) {
            throw new LibraryException("Unknown kind of widget '" + widgetName + "'.", DomHelper.getLocationObject(widgetDefinition));
        }
        context.setSuperDefinition(null);
        String extend = DomHelper.getAttribute(widgetDefinition, "extends", null);
        if (extend != null) {
            context.setSuperDefinition(this.getDefinition(extend));
        }
        WidgetDefinition definition = builder.buildWidgetDefinition(widgetDefinition, context);
        this.addDefinition(definition);
    }

    public void addDefinition(WidgetDefinition definition) throws LibraryException {
        if (definition == null) {
            return;
        }
        if (this.definitions.containsKey(definition.getId())) {
            throw new LibraryException("Library already contains a widget with this ID!");
        }
        definition.setEnclosingLibrary(this);
        this.definitions.put(definition.getId(), definition);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this + ": Added definition '" + definition.getId() + "'"));
        }
    }

    public void setWidgetDefinitionBuilderSelector(Map widgetDefinitionBuilderSelector) {
        this.widgetDefinitionBuilders = widgetDefinitionBuilderSelector;
    }

    protected class Dependency {
        private final String dependencyURI;
        private final Object shared;

        public Dependency(String dependencySourceURI) throws LibraryException {
            this.dependencyURI = dependencySourceURI;
            Library lib = Library.this.manager.load(this.dependencyURI, Library.this.sourceURI);
            this.shared = lib.shared;
        }

        public boolean isValid() throws LibraryException {
            Library lib = Library.this.manager.get(this.dependencyURI, Library.this.sourceURI);
            return lib != null && this.shared == lib.shared;
        }
    }
}

