/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.event.ValueChangedListener;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractWidgetDefinition;
import org.apache.cocoon.forms.formmodel.Upload;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;

public class UploadDefinition
extends AbstractWidgetDefinition {
    private ValueChangedListener listener;
    private boolean required;
    private String mimeTypes;

    public UploadDefinition() {
        this.mimeTypes = null;
        this.required = false;
    }

    public UploadDefinition(boolean required, String mimeTypes) {
        this.required = required;
        this.mimeTypes = mimeTypes;
    }

    public void initializeFrom(WidgetDefinition definition) throws Exception {
        super.initializeFrom(definition);
        if (!(definition instanceof UploadDefinition)) {
            throw new FormsException("Ancestor definition " + definition.getClass().getName() + " is not an UploadDefinition.", this.getLocation());
        }
        UploadDefinition other = (UploadDefinition)definition;
        this.required = other.required;
        this.mimeTypes = other.mimeTypes;
        this.listener = WidgetEventMulticaster.add(this.listener, other.listener);
    }

    public void addMimeTypes(String types) {
        if (types != null) {
            if (this.mimeTypes == null) {
                this.mimeTypes = types;
            } else {
                if (this.mimeTypes.length() > 0) {
                    this.mimeTypes = this.mimeTypes + ", ";
                }
                this.mimeTypes = this.mimeTypes + types;
            }
        }
    }

    public void setRequired(boolean required) {
        this.checkMutable();
        this.required = required;
    }

    public Widget createInstance() {
        return new Upload(this);
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getMimeTypes() {
        return this.mimeTypes;
    }

    public void addValueChangedListener(ValueChangedListener listener) {
        this.checkMutable();
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public ValueChangedListener getValueChangedListener() {
        return this.listener;
    }

    public boolean hasValueChangedListeners() {
        return this.listener != null;
    }
}

