/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.event.ValueChangedEvent;
import org.apache.cocoon.forms.event.ValueChangedListener;
import org.apache.cocoon.forms.formmodel.EnhancedRepeater;
import org.apache.cocoon.forms.formmodel.Field;
import org.apache.cocoon.forms.formmodel.RepeaterFilterFieldDefinition;
import org.apache.cocoon.forms.formmodel.Widget;

public class RepeaterFilterField
extends Field {
    private EnhancedRepeater repeater;
    private String field;

    public RepeaterFilterField(RepeaterFilterFieldDefinition fieldDefinition) {
        super(fieldDefinition);
        this.field = fieldDefinition.getField();
    }

    public void initialize() {
        super.initialize();
        String name = ((RepeaterFilterFieldDefinition)this.getDefinition()).getRepeaterName();
        Widget w = this.getParent().lookupWidget(name);
        if (w == null) {
            throw new IllegalArgumentException("Cannot find repeater named " + name);
        }
        if (!(w instanceof EnhancedRepeater)) {
            throw new IllegalArgumentException("The repeater named " + name + " is not an enhanced repeater");
        }
        this.repeater = (EnhancedRepeater)w;
        this.addValueChangedListener(new ValueChangedListener(){

            public void valueChanged(ValueChangedEvent event) {
                if (RepeaterFilterField.this.repeater.validate()) {
                    try {
                        RepeaterFilterField.this.repeater.setFilter(RepeaterFilterField.this.field, event.getNewValue());
                    }
                    catch (BindingException e) {
                        throw new RuntimeException("Error setting filter", (Throwable)((Object)e));
                    }
                }
            }
        });
    }
}

