/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Iterator;
import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.event.RepeaterListener;
import org.apache.cocoon.forms.formmodel.AbstractContainerDefinitionBuilder;
import org.apache.cocoon.forms.formmodel.RepeaterDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinitionBuilderContext;
import org.apache.cocoon.forms.util.DomHelper;
import org.w3c.dom.Element;

public final class RepeaterDefinitionBuilder
extends AbstractContainerDefinitionBuilder {
    public WidgetDefinition buildWidgetDefinition(Element repeaterElement, WidgetDefinitionBuilderContext context) throws Exception {
        int initialSize = DomHelper.getAttributeAsInteger(repeaterElement, "initial-size", 0);
        int minSize = DomHelper.getAttributeAsInteger(repeaterElement, "min-size", 0);
        int maxSize = DomHelper.getAttributeAsInteger(repeaterElement, "max-size", Integer.MAX_VALUE);
        if (minSize < 0) {
            throw new FormsException("min-size should be positive.", DomHelper.getLocationObject(repeaterElement));
        }
        if (maxSize < 0) {
            throw new FormsException("max-size should be positive.", DomHelper.getLocationObject(repeaterElement));
        }
        if (maxSize < minSize) {
            throw new FormsException("max-size should be greater than or equal to min-size.", DomHelper.getLocationObject(repeaterElement));
        }
        initialSize = minSize > initialSize ? minSize : initialSize;
        boolean orderable = DomHelper.getAttributeAsBoolean(repeaterElement, "orderable", false);
        boolean selectable = DomHelper.getAttributeAsBoolean(repeaterElement, "selectable", false);
        boolean enhanced = DomHelper.getAttributeAsBoolean(repeaterElement, "enhanced", false);
        int initialPage = 0;
        int pageSize = Integer.MAX_VALUE;
        String customPageId = null;
        Element pagesElement = DomHelper.getChildElement(repeaterElement, "http://apache.org/cocoon/forms/1.0#definition", "pages");
        if (pagesElement != null) {
            enhanced = true;
            initialPage = DomHelper.getAttributeAsInteger(pagesElement, "initial", 1) - 1;
            pageSize = DomHelper.getAttributeAsInteger(pagesElement, "size", 0);
            customPageId = DomHelper.getAttribute(pagesElement, "page-field", null);
        }
        RepeaterDefinition repeaterDefinition = new RepeaterDefinition(initialSize, minSize, maxSize, selectable, orderable, enhanced, initialPage, pageSize, customPageId);
        this.setupDefinition(repeaterElement, repeaterDefinition, context);
        this.setDisplayData(repeaterElement, repeaterDefinition);
        Iterator i = this.buildEventListeners(repeaterElement, "on-repeater-modified", RepeaterListener.class).iterator();
        while (i.hasNext()) {
            repeaterDefinition.addRepeaterListener((RepeaterListener)i.next());
        }
        this.setupContainer(repeaterElement, "widgets", repeaterDefinition, context);
        repeaterDefinition.makeImmutable();
        return repeaterDefinition;
    }
}

